/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.IOException;
import java.util.List;
import javax.vecmath.Matrix4f;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.xode.XODERoot;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XODEParserDOM {
    public static Logger log = Logger.getLogger("odejava.xode");
    public static Logger odeLog = Logger.getLogger("odejava.xode.call");
    private List geoms;
    private List bodies;
    private List joints;
    private List jointGroups;
    private List groups;
    private DOMParser parser = new DOMParser();
    private Document doc;

    public XODEParserDOM(boolean validate) {
        if (validate) {
            try {
                this.parser.setFeature("http://xml.org/sax/features/validation", true);
                this.parser.setFeature("http://xml.org/sax/features/validation", true);
                this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXNotRecognizedException e) {
                log.error("Unrecognized feature: http://xml.org/sax/features/validation");
            }
            catch (SAXNotSupportedException e) {
                log.error("Unrecognized feature: http://xml.org/sax/features/validation");
            }
        }
    }

    public XODERoot parse(World world, Space space, InputSource file) throws IOException, SAXException {
        Matrix4f identity = new Matrix4f();
        identity.setIdentity();
        return this.parse(world, space, file, identity);
    }

    public XODERoot parse(InputSource file) throws IOException, SAXException {
        Matrix4f identity = new Matrix4f();
        identity.setIdentity();
        return this.parse(file, identity);
    }

    public XODERoot parse(World world, Space space, InputSource file, Matrix4f parentTransform) throws IOException, SAXException {
        XODERoot root = this.parse(file, parentTransform);
        root.buildODEScene(world, space, "");
        return root;
    }

    public XODERoot parse(InputSource file, Matrix4f parentTransform) throws IOException, SAXException {
        this.parser.parse(file);
        this.doc = this.parser.getDocument();
        XODERoot root = new XODERoot(this.doc.getFirstChild(), parentTransform);
        System.gc();
        return root;
    }

    private static void display(Node start) {
        if (start.getNodeType() == 1) {
            System.out.print("<" + start.getNodeName());
            NamedNodeMap startAttr = start.getAttributes();
            for (int i = 0; i < startAttr.getLength(); ++i) {
                Node attr = startAttr.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
            System.out.print(">");
        } else if (start.getNodeType() == 3) {
            System.out.print(start.getNodeValue());
        }
        for (Node child = start.getFirstChild(); child != null; child = child.getNextSibling()) {
            XODEParserDOM.display(child);
        }
        if (start.getNodeType() == 1) {
            System.out.print("</" + start.getNodeName() + ">");
        }
    }

    public XODERoot parse(World world, Space space, String file, Matrix4f parentTransform) throws IOException, SAXException {
        return this.parse(world, space, new InputSource(file), parentTransform);
    }

    public XODERoot parse(World world, Space space, String file) throws IOException, SAXException {
        return this.parse(world, space, new InputSource(file));
    }

    public List getGeoms() {
        return this.geoms;
    }

    public List getBodies() {
        return this.bodies;
    }

    public List getJoints() {
        return this.joints;
    }

    public List getJointGroups() {
        return this.jointGroups;
    }

    public static final void main(String[] args) throws Exception {
        new XODEParserDOM(true).parse(null, null, "data/box.xml");
    }
}

