/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.List;
import org.odejava.Body;
import org.odejava.JointGroup;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.xode.DOMUtil;
import org.odejava.xode.XODEBody;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEJointGroup;
import org.odejava.xode.XODEParserDOM;
import org.odejava.xode.XODERoot;
import org.odejava.xode.XODESpace;
import org.w3c.dom.Node;

public abstract class XODEObject
implements Serializable {
    protected XODEContainer parent;
    protected String name;
    protected transient Object odeObject;
    protected transient Node node;

    protected XODEObject() {
    }

    public XODEObject(String name, XODEContainer parent) {
        this.name = name;
        this.parent = parent;
    }

    public XODEObject(XODEContainer parent, Node node) {
        if (parent != null) {
            this.parent = parent;
        }
        this.node = node;
        if (node != null) {
            XODEParserDOM.log.debug("Name attribute parsed: " + this.name);
            this.name = DOMUtil.attributeString(node, "name");
        }
    }

    public XODEObject(XODEContainer parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    protected Body getFirstBodyAncestor() {
        if (this instanceof XODERoot) {
            return null;
        }
        if (this instanceof XODEBody) {
            return (Body)((XODEBody)this).getODEObject();
        }
        return this.parent.getFirstBodyAncestor();
    }

    protected JointGroup getFirstJointGroupAncestor() {
        if (this instanceof XODERoot) {
            return null;
        }
        if (this instanceof XODEJointGroup) {
            return (JointGroup)((XODEJointGroup)this).getODEObject();
        }
        return this.parent.getFirstJointGroupAncestor();
    }

    protected Space getFirstSpaceAncestor() {
        if (this instanceof XODERoot) {
            return null;
        }
        if (this instanceof XODESpace) {
            return (Space)((XODESpace)this).getODEObject();
        }
        return this.parent.getFirstSpaceAncestor();
    }

    public Object getODEObject() {
        return this.odeObject;
    }

    public abstract void buildOde(World var1, Space var2, String var3, List var4);

    protected void setParent(XODEContainer parent) {
        if (this.parent != null && parent != null && this.parent != parent) {
            throw new XODEException("Attempting to assign a parent to this object when it already has one.");
        }
        this.parent = parent;
    }
}

