/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.odejava.Joint;
import org.odejava.xode.DOMUtil;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEJoint;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;

public class XODEJointAxis
implements Serializable {
    private static final Set LEGAL_ATTRIBUTES;
    private float x;
    private float y;
    private float z;
    private Map attributes = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$odejava$ode$Ode;

    protected XODEJointAxis() {
    }

    public XODEJointAxis(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public XODEJointAxis(float x, float y, float z, Float LowStop, Float HiStop, Float Vel, Float FMax, Float FudgeFactor, Float Bounce, Float CFM, Float StopERP, Float StopCFM, Float SuspensionERP, Float SuspensionCFM) {
        this(x, y, z);
        this.attributes.put("LowStop", LowStop);
        this.attributes.put("HiStop", HiStop);
        this.attributes.put("Vel", Vel);
        this.attributes.put("FMax", FMax);
        this.attributes.put("FudgeFactor", FudgeFactor);
        this.attributes.put("Bounce", Bounce);
        this.attributes.put("CFM", CFM);
        this.attributes.put("StopERP", StopERP);
        this.attributes.put("StopCFM", StopCFM);
        this.attributes.put("SuspensionERP", SuspensionERP);
        this.attributes.put("SuspensionCFM", SuspensionCFM);
    }

    public XODEJointAxis(Node axisNode) {
        Object transform = null;
        this.x = DOMUtil.attributeFloat(axisNode, "x");
        this.y = DOMUtil.attributeFloat(axisNode, "y");
        this.z = DOMUtil.attributeFloat(axisNode, "z");
        Node currentChild = axisNode;
        for (int j = 0; j < currentChild.getAttributes().getLength(); ++j) {
            String currentAttribute = currentChild.getAttributes().item(j).getNodeName();
            Float current = null;
            try {
                current = new Float(DOMUtil.attributeFloat(currentChild, currentAttribute));
            }
            catch (Exception e) {
                if (!LEGAL_ATTRIBUTES.contains(currentAttribute)) continue;
                throw new RuntimeException("Value for attribute " + currentAttribute + "not a float");
            }
            if (LEGAL_ATTRIBUTES.contains(currentAttribute)) {
                this.attributes.put(currentAttribute, current);
                continue;
            }
            XODEJoint.log.debug("Attribute " + currentAttribute + " is not a legal attribute!");
        }
    }

    public void addAxis(Joint joint, int numAxis) {
        XODEParserDOM.odeLog.debug("setAxis" + numAxis + "(" + new Float(this.x) + ", " + new Float(this.y) + ", " + new Float(this.z) + ")");
        if (numAxis == 1) {
            joint.setAxis1(this.x, this.y, this.z);
        } else if (numAxis == 2) {
            joint.setAxis2(this.x, this.y, this.z);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Axis is not 1 or 2");
        }
        Iterator i = this.attributes.keySet().iterator();
        while (i.hasNext()) {
            String currentAttribute = (String)i.next();
            int parameter = axisParamConverter.convert(currentAttribute, numAxis);
            joint.setParam(parameter, ((Float)this.attributes.get(currentAttribute)).floatValue());
        }
    }

    public Float getBounce() {
        return (Float)this.attributes.get("Bounce");
    }

    public void setBounce(Float bounce) {
        this.attributes.put("Bounce", bounce);
    }

    public Float getCFM() {
        return (Float)this.attributes.get("CFM");
    }

    public void setCFM(Float cfm) {
        this.attributes.put("CFM", cfm);
    }

    public Float getFMax() {
        return (Float)this.attributes.get("FMax");
    }

    public void setFMax(Float max) {
        this.attributes.put("FMax", max);
    }

    public Float getFudgeFactor() {
        return (Float)this.attributes.get("FudgeFactor");
    }

    public void setFudgeFactor(Float fudgeFactor) {
        this.attributes.put("FudgeFactor", fudgeFactor);
    }

    public Float getHiStop() {
        return (Float)this.attributes.get("HiStop");
    }

    public void setHiStop(Float hiStop) {
        this.attributes.put("HiStop", hiStop);
    }

    public Float getLowStop() {
        return (Float)this.attributes.get("LowStop");
    }

    public void setLowStop(Float lowStop) {
        this.attributes.put("LowStop", lowStop);
    }

    public Float getStopCFM() {
        return (Float)this.attributes.get("StopCFM");
    }

    public void setStopCFM(Float stopCFM) {
        this.attributes.put("StopCFM", stopCFM);
    }

    public Float getStopERP() {
        return (Float)this.attributes.get("StopERP");
    }

    public void setStopERP(Float stopERP) {
        this.attributes.put("StopERP", stopERP);
    }

    public Float getSuspensionCFM() {
        return (Float)this.attributes.get("SuspensionCFM");
    }

    public void setSuspensionCFM(Float suspensionCFM) {
        this.attributes.put("SuspensionCFM", suspensionCFM);
    }

    public Float getSuspensionERP() {
        return (Float)this.attributes.get("SuspensionERP");
    }

    public void setSuspensionERP(Float suspensionERP) {
        this.attributes.put("SuspensionERP", suspensionERP);
    }

    public Float getVel() {
        return (Float)this.attributes.get("Vel");
    }

    public void setVel(Float vel) {
        this.attributes.put("Vel", vel);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    static {
        $assertionsDisabled = !XODEJointAxis.class.desiredAssertionStatus();
        LEGAL_ATTRIBUTES = new HashSet<String>(Arrays.asList("LowStop", "HiStop", "Vel", "FMax", "FudgeFactor", "Bounce", "CFM", "StopERP", "StopCFM", "SuspensionERP", "SuspensionCFM"));
    }

    private static class axisParamConverter {
        static String[][] conversionTable = new String[][]{{"LowStop", "dParamLoStop"}, {"HiStop", "dParamHiStop"}, {"Vel", "dParamVel"}, {"FMax", "dParamFMax"}, {"FudgeFactor", "dParamFudgeFactor"}, {"Bounce", "dParamBounce"}, {"CFM", "dParamCFM"}, {"StopERP", "dParamStopERP"}, {"StopCFM", "dParamStopCFM"}, {"SuspensionERP", "dParamSuspensionERP"}, {"SuspensionCFM", "dParamSuspensionCFM"}};

        private axisParamConverter() {
        }

        static String convertName(String param) {
            String odeName = null;
            for (int i = 0; i < conversionTable.length; ++i) {
                if (!conversionTable[i][0].equals(param)) continue;
                odeName = conversionTable[i][1];
            }
            return odeName;
        }

        static int convert(String param, int axis) {
            System.out.println("param: " + param + " : " + axis);
            String odeName = axisParamConverter.convertName(param);
            System.out.println(odeName);
            try {
                return axis == 1 ? (class$org$odejava$ode$Ode == null ? (class$org$odejava$ode$Ode = XODEJointAxis.class$("org.odejava.ode.Ode")) : class$org$odejava$ode$Ode).getField(odeName).getInt(null) : (class$org$odejava$ode$Ode == null ? (class$org$odejava$ode$Ode = XODEJointAxis.class$("org.odejava.ode.Ode")) : class$org$odejava$ode$Ode).getField(odeName + axis).getInt(null);
            }
            catch (Exception e) {
                XODEJoint.log.error("Param: " + param + " does not appear to be a valid ODE axis property");
                throw new XODEException("Param: " + param + " does not appear to be a valid ODE axis property");
            }
        }
    }
}

