/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;
import org.odejava.Body;
import org.odejava.Joint;
import org.odejava.JointBall;
import org.odejava.JointFixed;
import org.odejava.JointGroup;
import org.odejava.JointHinge;
import org.odejava.JointHinge2;
import org.odejava.JointSlider;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.xode.DOMUtil;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEJointAxis;
import org.odejava.xode.XODEObject;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODEJoint
extends XODEObject
implements Serializable {
    protected String link1;
    protected String link2;
    protected Vector3f anchor;
    protected List axes = new LinkedList();
    protected String jointType;
    public static Logger log = Logger.getLogger("odejava.xode.joint");

    protected XODEJoint() {
    }

    public XODEJoint(String name, XODEContainer parent, Vector3f anchor, String link1, String link2, String jointType, List axes) {
        super(name, parent);
        this.anchor = anchor;
        this.link1 = link1;
        this.link2 = link2;
        this.jointType = jointType;
    }

    public XODEJoint(XODEContainer parent, Node xodeData) {
        super(parent, xodeData);
        Body parentBody = parent.getFirstBodyAncestor();
        JointGroup parentJointGroup = parent.getFirstJointGroupAncestor();
        if (parentJointGroup == null) {
            parentJointGroup = new JointGroup();
        }
        log.info("Parsing Joint Node");
        NodeList children = xodeData.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeName().equals("link1")) {
                log.debug("parsing link1 element");
                this.link1 = DOMUtil.attributeString(currentChild, "body");
            }
            if (currentChild.getNodeName().equals("link2")) {
                log.debug("parsing link2 element");
                this.link2 = DOMUtil.attributeString(currentChild, "body");
            }
            if (currentChild.getNodeName().equals("ball")) {
                XODEParserDOM.odeLog.debug("new JointBall");
                this.jointType = currentChild.getNodeName();
                this.anchor = XODEJoint.parseAnchor(currentChild);
                XODEParserDOM.odeLog.debug("JointBall.setAnchor " + this.anchor);
            }
            if (currentChild.getNodeName().equals("fixed")) {
                XODEParserDOM.odeLog.debug("new JointFixed");
                this.jointType = currentChild.getNodeName();
            }
            if (currentChild.getNodeName().equals("hinge")) {
                log.info("Now parsing: Hinge");
                XODEParserDOM.odeLog.debug("new JointHinge");
                this.jointType = currentChild.getNodeName();
                this.anchor = XODEJoint.parseAnchor(currentChild);
                XODEParserDOM.odeLog.debug("JointHinge.setAnchor " + this.anchor);
                log.debug("parsing axes");
                this.parseXODEAxis(currentChild);
            }
            if (currentChild.getNodeName().equals("slider")) {
                log.info("Now parsing: Slider");
                XODEParserDOM.odeLog.debug("new JointSlider");
                this.jointType = currentChild.getNodeName();
                log.debug("parsing axes");
                this.parseXODEAxis(currentChild);
            }
            if (!currentChild.getNodeName().equals("hinge2")) continue;
            log.info("Now parsing: Hinge2");
            XODEParserDOM.odeLog.debug("new JointHinge2");
            this.jointType = currentChild.getNodeName();
            this.anchor = XODEJoint.parseAnchor(currentChild);
            log.debug("parsing axes");
            this.parseXODEAxis(currentChild);
        }
    }

    public void parseXODEAxis(Node xodeData) {
        boolean numAxis = true;
        NodeList children = xodeData.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (!currentChild.getNodeName().equals("axis")) continue;
            this.axes.add(new XODEJointAxis(currentChild));
        }
    }

    public static Vector3f parseAnchor(Node jointNode) {
        Vector3f anchor = new Vector3f(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < jointNode.getChildNodes().getLength(); ++i) {
            Node currentChild = jointNode.getChildNodes().item(i);
            if (!currentChild.getNodeName().equals("anchor")) continue;
            anchor.x = DOMUtil.attributeFloat(currentChild, "x");
            anchor.y = DOMUtil.attributeFloat(currentChild, "y");
            anchor.z = DOMUtil.attributeFloat(currentChild, "z");
            break;
        }
        return anchor;
    }

    public Vector3f getAnchor() {
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.setIdentity();
        transformMatrix.setTranslation(new Vector3f(this.anchor.x, this.anchor.y, this.anchor.z));
        Matrix4f transform = this.parent.getTransform();
        transform.mul(transformMatrix);
        XODEParserDOM.log.debug("&&&&&&&&&&&&&&&&&&&&&& Anchor as parsed: " + new Vector3f(this.anchor.x, this.anchor.y, this.anchor.z));
        XODEParserDOM.log.debug("parent transform: " + this.anchor);
        Vector3f anchor = new Vector3f();
        transform.get(anchor);
        XODEParserDOM.log.debug("resultant transform: " + anchor);
        return anchor;
    }

    public void buildOde(World world, Space space, String namePrefix, List odeList) {
        Vector3f anchor;
        Joint joint;
        Body b;
        Body parentBody = this.parent.getFirstBodyAncestor();
        JointGroup parentJointGroup = this.parent.getFirstJointGroupAncestor();
        if (parentJointGroup == null) {
            parentJointGroup = new JointGroup();
        }
        Body link1 = null;
        Body link2 = null;
        log.debug("parsing link1 element");
        String id = namePrefix + this.link1;
        Iterator iter = world.getBodies().iterator();
        while (iter.hasNext()) {
            b = (Body)iter.next();
            if (!b.getName().equals(id)) continue;
            link1 = b;
            log.info("referenced Body found id:" + id);
        }
        if (link1 == null) {
            log.error("link1 referenced body could NOT be found");
        }
        if (link1 == null) {
            link1 = parentBody;
        }
        log.debug("parsing link2 element");
        id = namePrefix + this.link2;
        iter = world.getBodies().iterator();
        while (iter.hasNext()) {
            b = (Body)iter.next();
            if (!b.getName().equals(id)) continue;
            link2 = b;
            log.debug("referenced Body found id:" + id);
        }
        if (link2 == null) {
            log.error("link2 referenced body could NOT be found");
        }
        if (link2 == null) {
            link2 = parentBody;
        }
        if (link1 == link2) {
            throw new XODEException("Not Happy Jan, link1 and link2 are equal!");
        }
        log.warn("link1: " + link1.getName() + " link2: " + link2.getName());
        if (this.jointType.equals("ball")) {
            XODEParserDOM.odeLog.debug("new JointBall");
            joint = new JointBall(world, parentJointGroup);
            XODEParserDOM.odeLog.debug("JointBall.attach");
            joint.attach(link1, link2);
            anchor = this.getAnchor();
            XODEParserDOM.odeLog.debug("JointBall.setAnchor " + anchor);
            ((JointBall)joint).setAnchor(anchor.x, anchor.y, anchor.z);
            this.odeObject = joint;
        }
        if (this.jointType.equals("fixed")) {
            XODEParserDOM.odeLog.debug("new JointFixed");
            joint = new JointFixed(world, new JointGroup());
            XODEParserDOM.odeLog.debug("JointFixed.attach");
            joint.attach(link1, link2);
            XODEParserDOM.odeLog.debug("JointFixed.setFixed");
            ((JointFixed)joint).setFixed();
            this.odeObject = joint;
        }
        if (this.jointType.equals("hinge")) {
            log.info("Now parsing: Hinge");
            XODEParserDOM.odeLog.debug("new JointHinge");
            joint = new JointHinge(world, new JointGroup());
            XODEParserDOM.odeLog.debug("JointHinge.attach");
            joint.attach(link1, link2);
            anchor = this.getAnchor();
            XODEParserDOM.odeLog.debug("JointHinge.setAnchor " + anchor);
            ((JointHinge)joint).setAnchor(anchor.x, anchor.y, anchor.z);
            log.debug("parsing axes");
            this.addAxes(joint);
            log.debug("Param Test - Lowstop value is " + ((JointHinge)joint).getParam(Ode.dParamLoStop));
            log.debug("Param Test - Highstop value is " + ((JointHinge)joint).getParam(Ode.dParamHiStop));
            log.debug("Param Test - Axis value is " + ((JointHinge)joint).getAxis());
            log.info("Hinge Parsing Complete");
            this.odeObject = joint;
        }
        if (this.jointType.equals("slider")) {
            log.info("Now parsing: Slider");
            XODEParserDOM.odeLog.debug("new JointSlider");
            joint = new JointSlider(world, new JointGroup());
            XODEParserDOM.odeLog.debug("JointSlider.attach");
            joint.attach(link1, link2);
            log.debug("parsing axes");
            this.addAxes(joint);
            log.info("Hinge2 Parsing Complete");
            this.odeObject = joint;
        }
        if (this.jointType.equals("hinge2")) {
            log.info("Now parsing: Hinge2");
            XODEParserDOM.odeLog.debug("new JointHinge2");
            joint = new JointHinge2(world, new JointGroup());
            if (link2 != null) {
                XODEParserDOM.odeLog.debug("JointHinge2.attach");
                joint.attach(link1, link2);
            }
            anchor = this.getAnchor();
            XODEParserDOM.odeLog.debug("JointHinge2.setAnchor " + anchor);
            ((JointHinge2)joint).setAnchor(anchor.x, anchor.y, anchor.z);
            log.debug("parsing axes");
            this.addAxes(joint);
            log.debug("Param Test - Lowstop value is " + ((JointHinge2)joint).getParam(Ode.dParamLoStop));
            log.debug("Param Test - Highstop value is " + ((JointHinge2)joint).getParam(Ode.dParamHiStop));
            log.debug("Param Test - Axis value is " + ((JointHinge2)joint).getAxis1());
            log.debug("Param Test - Anchor value is " + ((JointHinge2)joint).getAnchor());
            log.info("Hinge2 Parsing Complete");
            this.odeObject = joint;
        }
        if (this.odeObject != null && this.name != null) {
            ((Joint)this.odeObject).setName(namePrefix + this.name);
        }
        odeList.add(this.odeObject);
    }

    public void addAxes(Joint joint) {
        int count = 1;
        ListIterator i = this.axes.listIterator();
        while (i.hasNext()) {
            ((XODEJointAxis)i.next()).addAxis(joint, count);
            ++count;
        }
    }
}

