/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import javax.vecmath.Matrix4f;
import org.odejava.xode.XODEBody;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEGeomBox;
import org.odejava.xode.XODEGeomCappedCylinder;
import org.odejava.xode.XODEGeomCone;
import org.odejava.xode.XODEGeomCylinder;
import org.odejava.xode.XODEGeomPlane;
import org.odejava.xode.XODEGeomRay;
import org.odejava.xode.XODEGeomSphere;
import org.odejava.xode.XODEJoint;
import org.odejava.xode.XODEJointGroup;
import org.odejava.xode.XODEParserDOM;
import org.odejava.xode.XODESpace;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODEGroup
extends XODEContainer
implements Serializable {
    protected XODEGroup() {
    }

    public XODEGroup(String name, XODEContainer parent, Matrix4f transform) {
        super(name, parent, transform);
    }

    public XODEGroup(XODEContainer parent, Node xodeData) {
        this(parent, xodeData, true);
    }

    public XODEGroup(XODEContainer parent, Node xodeData, boolean parseData) {
        super(parent, xodeData);
        if (parseData) {
            this.parseTransform(xodeData);
            this.parseGroup(xodeData);
        }
    }

    protected void parseGroup(Node xodeData) {
        XODEParserDOM.log.debug("Group!");
        NodeList children = xodeData.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            this.parseGroupChild(currentChild);
        }
    }

    protected void parseGroupChild(Node currentChild) {
        if (currentChild.getNodeName().equals("body")) {
            this.addChild(new XODEBody((XODEContainer)this, currentChild));
        } else {
            if (currentChild.getNodeName().equals("geom")) {
                NodeList children = currentChild.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    String geomType = children.item(i).getNodeName();
                    if (geomType.equals("box")) {
                        this.addChild(new XODEGeomBox((XODEContainer)this, currentChild));
                        return;
                    }
                    if (geomType.equals("sphere")) {
                        this.addChild(new XODEGeomSphere((XODEContainer)this, currentChild));
                        return;
                    }
                    if (geomType.equals("plane")) {
                        this.addChild(new XODEGeomPlane((XODEContainer)this, currentChild));
                        return;
                    }
                    if (geomType.equals("cylinder")) {
                        this.addChild(new XODEGeomCylinder((XODEContainer)this, currentChild));
                        return;
                    }
                    if (geomType.equals("cone")) {
                        this.addChild(new XODEGeomCone((XODEContainer)this, currentChild));
                        return;
                    }
                    if (geomType.equals("cappedCylinder")) {
                        this.addChild(new XODEGeomCappedCylinder((XODEContainer)this, currentChild));
                        return;
                    }
                    if (geomType.equals("ray")) {
                        this.addChild(new XODEGeomRay((XODEContainer)this, currentChild));
                        return;
                    }
                    if (!geomType.equals("trimesh")) continue;
                    throw new XODEException("trimesh isn't supported yet");
                }
                throw new XODEException("unable to find child geom object in: " + currentChild.getNodeName());
            }
            if (currentChild.getNodeName().equals("joint")) {
                this.addChild(new XODEJoint((XODEContainer)this, currentChild));
            } else if (currentChild.getNodeName().equals("group")) {
                this.addChild(new XODEGroup((XODEContainer)this, currentChild));
            } else if (currentChild.getNodeName().equals("jointgroup")) {
                this.addChild(new XODEJointGroup((XODEContainer)this, currentChild));
            } else if (currentChild.getNodeName().equals("space")) {
                this.addChild(new XODESpace((XODEContainer)this, currentChild));
            }
        }
    }
}

