/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import javax.vecmath.Matrix4f;
import org.odejava.Geom;
import org.odejava.GeomSphere;
import org.odejava.xode.DOMUtil;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEGeom;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODEGeomSphere
extends XODEGeom
implements Serializable {
    private float radius;

    protected XODEGeomSphere() {
    }

    public XODEGeomSphere(float radius) {
        this.radius = radius;
    }

    public XODEGeomSphere(XODEContainer parent, Node xodeData) {
        super(parent, xodeData);
        try {
            XODEParserDOM.log.debug("Geom!");
            this.parseTransform(xodeData);
            NodeList children = xodeData.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node currentChild = children.item(i);
                if (currentChild.getNodeName().equals("sphere")) {
                    this.radius = DOMUtil.attributeFloat(currentChild, "radius");
                    continue;
                }
                this.parseGroupChild(currentChild);
            }
        }
        catch (NumberFormatException e) {
            throw new XODEException("Error parsing numeric values", e);
        }
    }

    public XODEGeomSphere(Geom currentGeom, Matrix4f transform) {
        throw new XODEException("unimplemented");
    }

    public Geom getGeom() {
        return new GeomSphere(this.radius);
    }

    public float getRadius() {
        return this.radius;
    }
}

