/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import javax.vecmath.Matrix4f;
import org.odejava.Geom;
import org.odejava.GeomPlane;
import org.odejava.xode.DOMUtil;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEGeom;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODEGeomPlane
extends XODEGeom
implements Serializable {
    private float a;
    private float b;
    private float c;
    private float d;

    protected XODEGeomPlane() {
    }

    public XODEGeomPlane(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public XODEGeomPlane(XODEContainer parent, Node xodeData) {
        super(parent, xodeData);
        boolean hasTransform = false;
        try {
            XODEParserDOM.log.debug("Geom!");
            this.parseTransform(xodeData);
            NodeList children = xodeData.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node currentChild = children.item(i);
                if (currentChild.getNodeName().equals("plane")) {
                    this.a = DOMUtil.attributeFloat(currentChild, "a");
                    this.b = DOMUtil.attributeFloat(currentChild, "b");
                    this.c = DOMUtil.attributeFloat(currentChild, "c");
                    this.d = DOMUtil.attributeFloat(currentChild, "d");
                    continue;
                }
                this.parseGroupChild(currentChild);
            }
        }
        catch (NumberFormatException e) {
            throw new XODEException("Error parsing numeric values", e);
        }
    }

    public XODEGeomPlane(Geom currentGeom, Matrix4f transform) {
        throw new XODEException("unimplemented");
    }

    public Geom getGeom() {
        return new GeomPlane(this.a, this.b, this.c, this.d);
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getC() {
        return this.c;
    }

    public float getD() {
        return this.d;
    }
}

