/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import javax.vecmath.Matrix4f;
import org.odejava.Geom;
import org.odejava.GeomBox;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEGeom;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODEGeomBox
extends XODEGeom
implements Serializable {
    private float sizex;
    private float sizey;
    private float sizez;

    protected XODEGeomBox() {
    }

    public XODEGeomBox(float sizex, float sizey, float sizez) {
        this.sizex = sizex;
        this.sizey = sizey;
        this.sizez = sizez;
    }

    public XODEGeomBox(XODEContainer parent, Node xodeData) {
        super(parent, xodeData);
        try {
            XODEParserDOM.log.debug("Geom!");
            this.parseTransform(xodeData);
            NodeList children = xodeData.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node currentChild = children.item(i);
                if (currentChild.getNodeName().equals("box")) {
                    this.sizex = Float.parseFloat(currentChild.getAttributes().getNamedItem("sizex").getNodeValue());
                    this.sizey = Float.parseFloat(currentChild.getAttributes().getNamedItem("sizey").getNodeValue());
                    this.sizez = Float.parseFloat(currentChild.getAttributes().getNamedItem("sizez").getNodeValue());
                    continue;
                }
                this.parseGroupChild(currentChild);
            }
        }
        catch (NumberFormatException e) {
            throw new XODEException("Error parsing numeric values", e);
        }
    }

    public XODEGeomBox(Geom currentGeom, Matrix4f transform) {
        throw new XODEException("unimplemented");
    }

    public Geom getGeom() {
        return new GeomBox(this.sizex, this.sizey, this.sizez);
    }
}

