/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.GeomTransform;
import org.odejava.PlaceableGeom;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEGroup;
import org.odejava.xode.XODEParserDOM;
import org.w3c.dom.Node;

public abstract class XODEGeom
extends XODEGroup
implements Serializable {
    protected XODEGeom() {
    }

    protected XODEGeom(String name, XODEContainer parent, Matrix4f transform) {
        super(name, parent, transform);
    }

    public XODEGeom(XODEContainer parent, Node xodeData) {
        super(parent, xodeData, false);
    }

    public abstract Geom getGeom();

    public void buildOde(World world, Space space, String namePrefix, List odeList) {
        Body parentBody = this.getFirstBodyAncestor();
        Geom geom = this.getGeom();
        geom.setName(namePrefix + this.name);
        XODEParserDOM.log.debug("Processing Geom: " + geom.getName());
        XODEParserDOM.log.debug(space);
        if (parentBody != null) {
            Matrix4f bodyRelTransform = this.getBodyRelTransform();
            Matrix4f identity = new Matrix4f();
            identity.setIdentity();
            if (!bodyRelTransform.equals(identity)) {
                GeomTransform tg = new GeomTransform();
                tg.setEncapsulatedGeom((PlaceableGeom)geom);
                parentBody.addGeom(tg);
                tg.setName(geom.getName());
                space.add(tg);
                Vector3f position = new Vector3f();
                bodyRelTransform.get(position);
                Quat4f rotation = new Quat4f();
                bodyRelTransform.get(rotation);
                ((PlaceableGeom)geom).setPosition(position);
                ((PlaceableGeom)geom).setQuaternion(rotation);
                geom = tg;
            } else {
                parentBody.addGeom((PlaceableGeom)geom);
                space.add(geom);
            }
        } else {
            space.add(geom);
            XODEParserDOM.odeLog.debug("Geom.setPosition " + this.getPosition());
            ((PlaceableGeom)geom).setPosition(this.getPosition());
            XODEParserDOM.odeLog.debug("Geom.setQuaternion " + this.getRotation());
            ((PlaceableGeom)geom).setQuaternion(this.getRotation());
        }
        this.odeObject = geom;
        odeList.add(geom);
        this.addChildren(world, space, namePrefix, odeList);
    }
}

