/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.xode.XODEBody;
import org.odejava.xode.XODEException;
import org.odejava.xode.XODEObject;
import org.odejava.xode.XODEParserDOM;
import org.odejava.xode.XODERoot;
import org.odejava.xode.XODETransform;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XODEContainer
extends XODEObject
implements Serializable {
    protected List xodeObjects = new LinkedList();
    protected Matrix4f relTransform = new Matrix4f();
    protected boolean absoluteTransform = false;
    protected transient Matrix4f cachedTransform = null;
    protected transient Matrix4f cachedBodyRelTransform = null;
    protected transient Matrix4f cachedRootTransform = null;

    protected XODEContainer() {
        this.relTransform.setIdentity();
    }

    public XODEContainer(String name, XODEContainer parent, Matrix4f transform) {
        super(name, parent);
        this.relTransform.set(transform);
    }

    public XODEContainer(XODEContainer parent, Node node) {
        super(parent, node);
        this.relTransform.setIdentity();
    }

    protected void parseTransform(Node xodeData) {
        NodeList children = xodeData.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (!currentChild.getNodeName().equals("transform")) continue;
            this.relTransform = XODETransform.parseTransformNode(currentChild);
            break;
        }
    }

    public Matrix4f getRootTransform() {
        if (this.cachedRootTransform != null) {
            return this.cachedRootTransform;
        }
        if (this instanceof XODERoot) {
            Matrix4f rootTransform = new Matrix4f();
            rootTransform.set(this.relTransform);
            return rootTransform;
        }
        if (this.parent == null) {
            this.cachedRootTransform = new Matrix4f();
            this.cachedRootTransform.setIdentity();
        } else {
            this.cachedRootTransform = this.parent.getRootTransform();
        }
        return this.cachedRootTransform;
    }

    public Matrix4f getBodyRelTransform() {
        if (this.cachedBodyRelTransform != null) {
            return this.cachedBodyRelTransform;
        }
        if (this instanceof XODEBody) {
            Matrix4f identity = new Matrix4f();
            identity.setIdentity();
            return identity;
        }
        if (this instanceof XODERoot) {
            throw new XODEException("Root node reached - no Body ancestor found");
        }
        if (this.parent == null) {
            throw new XODEException("Null parent encountered - no Body ancestor found");
        }
        Matrix4f parent = this.parent.getBodyRelTransform();
        XODEParserDOM.log.debug("^^^ parent " + parent);
        Matrix4f child = this.relTransform;
        XODEParserDOM.log.debug("^^^ child " + this.name + " " + this.getClass().getName() + "\n" + child);
        parent.mul(child);
        this.cachedBodyRelTransform = new Matrix4f();
        this.cachedBodyRelTransform.set(parent);
        return parent;
    }

    public void buildOde(World world, Space space, String namePrefix, List odeList) {
        this.addChildren(world, space, namePrefix, odeList);
    }

    public void addChildren(World world, Space space, String namePrefix, List odeList) {
        Iterator i = this.xodeObjects.iterator();
        while (i.hasNext()) {
            ((XODEObject)i.next()).buildOde(world, space, namePrefix, odeList);
        }
    }

    public void addChild(XODEObject toAdd) {
        this.xodeObjects.add(toAdd);
        toAdd.setParent(this);
    }

    public List getChildren() {
        return this.xodeObjects;
    }

    private final void calculateTransform() {
        if (this.cachedTransform == null) {
            this.cachedTransform = new Matrix4f();
            if (this.absoluteTransform) {
                this.cachedTransform.set(this.getRootTransform());
            } else if (this.parent != null) {
                this.parent.getTransform(this.cachedTransform);
            } else {
                this.cachedTransform.setIdentity();
            }
            this.cachedTransform.mul(this.relTransform);
        }
    }

    public final Matrix4f getTransform() {
        return this.getTransform(new Matrix4f());
    }

    public final Matrix4f getTransform(Matrix4f transform) {
        this.calculateTransform();
        transform.set(this.cachedTransform);
        return transform;
    }

    public Vector3f getPosition() {
        this.calculateTransform();
        Vector3f result = new Vector3f();
        this.cachedTransform.get(result);
        return result;
    }

    public Quat4f getRotation() {
        this.calculateTransform();
        Quat4f result = new Quat4f();
        this.cachedTransform.get(result);
        return result;
    }

    public void setPosition(Vector3f position) {
        this.relTransform.setTranslation(position);
        this.invalidateTransformCache();
    }

    public void setRotation(Quat4f rotation) {
        this.relTransform.setRotation(rotation);
        this.invalidateTransformCache();
    }

    public void setTransform(Matrix4f transform) {
        this.relTransform.set(transform);
        this.invalidateTransformCache();
    }

    public void setAbsolute(boolean absolute) {
        this.absoluteTransform = absolute;
    }

    public boolean isAbsoluteTransformMode() {
        return this.absoluteTransform;
    }

    public void invalidateTransformCache() {
        this.cachedTransform = null;
        this.cachedBodyRelTransform = null;
        this.cachedRootTransform = null;
        Iterator i = this.xodeObjects.iterator();
        while (i.hasNext()) {
            XODEObject currentChild = (XODEObject)i.next();
            if (!(currentChild instanceof XODEContainer)) continue;
            ((XODEContainer)currentChild).invalidateTransformCache();
        }
    }

    public void scrapODEObjectCache() {
        this.odeObject = null;
        Iterator i = this.xodeObjects.iterator();
        while (i.hasNext()) {
            XODEObject currentChild = (XODEObject)i.next();
            if (currentChild instanceof XODEContainer) {
                ((XODEContainer)currentChild).scrapODEObjectCache();
                continue;
            }
            currentChild.odeObject = null;
        }
    }

    protected void setParent(XODEContainer parent) {
        super.setParent(parent);
        this.invalidateTransformCache();
    }
}

