/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.xode;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4f;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.xode.DOMUtil;
import org.odejava.xode.XODEContainer;
import org.odejava.xode.XODEGroup;
import org.odejava.xode.XODEParserDOM;
import org.odejava.xode.XODESpace;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XODEBody
extends XODEGroup
implements Serializable {
    protected Float finiteRotationMode;
    protected Float finiteRotationAxisX;
    protected Float finiteRotationAxisY;
    protected Float finiteRotationAxisZ;
    protected Float totalMass;

    protected XODEBody() {
    }

    public XODEBody(String name, XODEContainer parent, Matrix4f transform) {
        super(name, parent, transform);
    }

    public XODEBody(XODEContainer parent, Node xodeData) {
        super(parent, xodeData, false);
        XODEParserDOM.log.debug("Body!");
        this.parseTransform(xodeData);
        NodeList children = xodeData.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeName().equals("finiteRotation")) {
                this.finiteRotationMode = new Float(DOMUtil.attributeFloat(currentChild, "mode"));
                try {
                    this.finiteRotationAxisX = new Float(DOMUtil.attributeFloat(currentChild, "xaxis"));
                    this.finiteRotationAxisY = new Float(DOMUtil.attributeFloat(currentChild, "yaxis"));
                    this.finiteRotationAxisZ = new Float(DOMUtil.attributeFloat(currentChild, "zaxis"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (currentChild.getNodeName().equals("mass")) {
                NodeList massChildren = currentChild.getChildNodes();
                for (int j = 0; j < massChildren.getLength(); ++j) {
                    Node totalAttr;
                    Node currentMassChild = massChildren.item(j);
                    if (!currentMassChild.getNodeName().equals("adjust") || (totalAttr = currentMassChild.getAttributes().getNamedItem("total")) == null) continue;
                    XODEParserDOM.odeLog.debug("Body.adjustMass " + Float.parseFloat(totalAttr.getNodeValue()));
                    this.totalMass = new Float(totalAttr.getNodeValue());
                }
            }
            this.parseGroupChild(currentChild);
            XODEParserDOM.odeLog.debug("Body.setPosition " + this.getPosition());
            XODEParserDOM.odeLog.debug("Body.setQuaternion " + this.getRotation());
        }
    }

    public XODEBody(Body body) {
        this.name = body.getName();
        this.setAbsolute(true);
        this.setPosition(body.getPosition());
        this.setRotation(body.getQuaternion());
        Iterator i = body.getGeoms().iterator();
        while (i.hasNext()) {
            XODESpace.addChild(this, (Geom)i.next());
        }
    }

    public void buildOde(World world, Space space, String namePrefix, List odeList) {
        Body boxBody = new Body(namePrefix + this.name, world);
        this.odeObject = boxBody;
        if (this.finiteRotationMode != null) {
            boxBody.setFiniteRotationMode((int)this.finiteRotationMode.floatValue());
            if (this.finiteRotationAxisX != null && this.finiteRotationAxisY != null && this.finiteRotationAxisZ != null) {
                boxBody.setFiniteRotationAxis(this.finiteRotationAxisX.floatValue(), this.finiteRotationAxisY.floatValue(), this.finiteRotationAxisZ.floatValue());
            }
        }
        if (this.totalMass != null) {
            boxBody.adjustMass(this.totalMass.floatValue());
        }
        boxBody.setPosition(this.getPosition());
        boxBody.setQuaternion(this.getRotation());
        odeList.add(boxBody);
        this.addChildren(world, space, namePrefix, odeList);
        boxBody.adjustMass(1.0f);
    }
}

