/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.test.xode;

import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.HashSpace;
import org.odejava.Odejava;
import org.odejava.World;
import org.odejava.collision.Contact;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.Ode;
import org.odejava.test.Demonstration;
import org.odejava.xode.XODEParserDOM;
import org.odejava.xode.XODERoot;
import org.xml.sax.InputSource;

public class XODEExample
implements Demonstration {
    private World world = new World();
    private HashSpace space;
    private JavaCollision collision;
    public static final Vector3f gravity = new Vector3f(0.0f, -9.82f, 0.0f);
    Contact contact;

    public XODEExample() throws Exception {
        this.world.setGravity(XODEExample.gravity.x, XODEExample.gravity.y, XODEExample.gravity.z);
        this.world.setStepInteractions(10);
        this.world.setStepSize(0.05f);
        this.space = new HashSpace();
        this.collision = new JavaCollision(this.world);
        this.contact = new Contact(this.collision.getContactIntBuffer(), this.collision.getContactFloatBuffer());
        this.collision.setSurfaceMu(1.0f);
        this.collision.setSurfaceBounce(0.14f);
        this.collision.setSurfaceBounceVel(0.1f);
        this.collision.setSurfaceMode(Ode.dContactBounce | Ode.dContactApprox1);
        this.collision.setSurfaceMode(0);
        this.collision.setSurfaceMu(Float.MAX_VALUE);
        XODERoot root = new XODEParserDOM(true).parse(new InputSource(XODEExample.class.getClassLoader().getResourceAsStream("data/boxsphere.xml")));
        root.buildODEScene(this.world, this.space, "1");
        Vector3f position = new Vector3f(1.0f, 3.0f, 25.0f);
        Matrix4f m1 = new Matrix4f();
        m1.setIdentity();
        m1.setTranslation(position);
        root.setRootTransform(m1);
        root.buildODEScene(this.world, this.space, "2");
    }

    public void step() {
        Body boxBody = this.world.getBody("1chassis");
        this.collision.collide(this.space);
        for (int i = 0; i < this.collision.getContactCount(); ++i) {
            this.contact.setIndex(i);
        }
        this.collision.applyContacts();
        this.world.step();
        System.out.println(boxBody.getPosition());
    }

    public List getGeoms() {
        return this.space.getGeoms();
    }

    public static final void main(String[] args) throws Exception {
        XODEExample demo = new XODEExample();
        while (true) {
            demo.step();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
            }
        }
    }

    static {
        Odejava.getInstance();
    }
}

