/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.test.xode;

import java.util.List;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.GeomBox;
import org.odejava.GeomSphere;
import org.odejava.HashSpace;
import org.odejava.Odejava;
import org.odejava.World;
import org.odejava.collision.Contact;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.Ode;
import org.odejava.test.Demonstration;

public class NormalTest
implements Demonstration {
    private World world = new World();
    private HashSpace space;
    private JavaCollision collision;
    public static final Vector3f gravity = new Vector3f(0.0f, -9.82f, 0.0f);
    Contact contact;

    public NormalTest() throws Exception {
        this.world.setGravity(NormalTest.gravity.x, NormalTest.gravity.y, NormalTest.gravity.z);
        this.world.setStepInteractions(10);
        this.world.setStepSize(0.05f);
        this.space = new HashSpace();
        this.collision = new JavaCollision(this.world);
        this.contact = new Contact(this.collision.getContactIntBuffer(), this.collision.getContactFloatBuffer());
        this.collision.setSurfaceMu(1.0f);
        this.collision.setSurfaceBounce(0.14f);
        this.collision.setSurfaceBounceVel(0.1f);
        this.collision.setSurfaceMode(Ode.dContactBounce | Ode.dContactApprox1);
        this.collision.setSurfaceMode(0);
        this.collision.setSurfaceMu(Float.MAX_VALUE);
        Body boxBody = new Body("box", this.world, new GeomBox(4.0f, 4.0f, 4.0f));
        boxBody.setPosition(0.1f, 4.0f, 2.0f);
        boxBody.adjustMass(1.0f);
        this.space.addBodyGeoms(boxBody);
        Body sphereBody = new Body("sphere", this.world, new GeomSphere(2.0f));
        sphereBody.setPosition(0.5f, 1.8f, 2.3f);
        sphereBody.adjustMass(1.0f);
        this.space.addBodyGeoms(sphereBody);
        GeomBox planeGeom = new GeomBox("plane", 100.0f, 1.0f, 100.0f);
        planeGeom.setPosition(0.1f, -7.0f, 0.0f);
        this.space.add(planeGeom);
    }

    public void step() {
        this.collision.collide(this.space);
        for (int i = 0; i < this.collision.getContactCount(); ++i) {
            this.contact.setIndex(i);
        }
        this.collision.applyContacts();
        this.world.step();
    }

    public List getGeoms() {
        return this.space.getGeoms();
    }

    public static final void main(String[] args) throws Exception {
        NormalTest demo = new NormalTest();
        while (true) {
            demo.step();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
            }
        }
    }

    static {
        Odejava.getInstance();
    }
}

