/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.test.simple;

import java.util.List;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.GeomBox;
import org.odejava.GeomPlane;
import org.odejava.GeomSphere;
import org.odejava.GeomTriMesh;
import org.odejava.HashSpace;
import org.odejava.Odejava;
import org.odejava.World;
import org.odejava.collision.Contact;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.Ode;

public class TriMesh {
    World world;
    HashSpace space;
    public Body sphere1;
    public Body sphere2;
    public Body sphere3;
    public Body sphere4;
    public Body box;
    GeomTriMesh pyramidGeom;
    GeomPlane groundGeom;
    JavaCollision collision;
    Contact contact;
    Vector3f fdir1 = new Vector3f();
    Vector3f pos = new Vector3f();
    Vector3f normal = new Vector3f();

    public TriMesh() {
        Odejava.getInstance();
        this.initWorld();
        this.initEnvironment();
        this.initObjects();
    }

    private void initWorld() {
        this.world = new World();
        this.world.setGravity(0.0f, 0.0f, -0.2f);
        this.world.setStepInteractions(10);
        this.world.setStepSize(0.05f);
        this.collision = new JavaCollision(this.world);
        this.contact = new Contact(this.collision.getContactIntBuffer(), this.collision.getContactFloatBuffer());
        this.space = new HashSpace();
        this.collision.setSurfaceMode(0);
        this.collision.setSurfaceMu(Float.MAX_VALUE);
    }

    private void initEnvironment() {
        this.groundGeom = new GeomPlane("ground", 0.0f, 0.0f, 1.0f, 0.0f);
        this.space.addGeom(this.groundGeom);
        int vertexCount = 15;
        int indexCount = 12;
        float[] vertices = new float[vertexCount];
        int[] indices = new int[indexCount];
        float[] size = new float[]{25.0f, 25.0f, 20.0f};
        vertices[0] = -size[0];
        vertices[1] = -size[1];
        vertices[2] = size[2];
        vertices[3] = size[0];
        vertices[4] = -size[1];
        vertices[5] = size[2];
        vertices[6] = size[0];
        vertices[7] = size[1];
        vertices[8] = size[2];
        vertices[9] = -size[0];
        vertices[10] = size[1];
        vertices[11] = size[2];
        vertices[12] = 0.0f;
        vertices[13] = 0.0f;
        vertices[14] = 0.0f;
        int i = 0;
        indices[i++] = 1;
        indices[i++] = 2;
        indices[i++] = 4;
        indices[i++] = 0;
        indices[i++] = 1;
        indices[i++] = 4;
        indices[i++] = 3;
        indices[i++] = 0;
        indices[i++] = 4;
        indices[i++] = 2;
        indices[i++] = 3;
        indices[i++] = 4;
        this.pyramidGeom = new GeomTriMesh("pyramid", vertices, indices);
        this.pyramidGeom.setPosition(0.0f, 0.0f, -2.5f);
        this.space.addGeom(this.pyramidGeom);
    }

    private void initObjects() {
        float x = 4.0f;
        float y = 4.0f;
        this.box = new Body("box", this.world, new GeomBox(2.0f, 1.0f, 1.0f));
        this.box.setPosition(x + 0.0f, y + 0.0f, 20.0f);
        this.box.adjustMass(1.0f);
        this.space.addBodyGeoms(this.box);
        this.sphere1 = new Body("sphere1", this.world, new GeomSphere(3.0f));
        this.sphere1.setPosition(x + 2.0f, y + -1.01f, 30.0f);
        this.sphere1.adjustMass(0.2f);
        this.space.addBodyGeoms(this.sphere1);
        this.sphere2 = new Body("sphere2", this.world, new GeomSphere(1.0f));
        this.sphere2.setPosition(x + 1.01f, y + -1.01f, 25.0f);
        this.sphere2.adjustMass(1.0f);
        this.space.addBodyGeoms(this.sphere2);
        this.sphere3 = new Body("sphere3", this.world, new GeomSphere(1.0f));
        this.sphere3.setPosition(x + -1.01f, y + 1.01f, 25.0f);
        this.sphere3.adjustMass(1.0f);
        this.space.addBodyGeoms(this.sphere3);
        this.sphere4 = new Body("sphere4", this.world, new GeomSphere(1.0f));
        this.sphere4.setPosition(x + 1.01f, y + 1.01f, 35.0f);
        this.sphere4.adjustMass(1.0f);
        this.space.addBodyGeoms(this.sphere4);
    }

    public void step() {
        this.collision.collide(this.space);
        this.iterateContacts();
        this.collision.applyContacts();
        this.world.stepFast();
    }

    private void iterateContacts() {
        float depth = 0.0f;
        Vector3f pos = new Vector3f();
        Vector3f normal = new Vector3f();
        for (int i = 0; i < this.collision.getContactCount(); ++i) {
            this.contact.setIndex(i);
            if (this.contact.getGeomID1() == this.groundGeom.getNativeAddr() || this.contact.getGeomID2() == this.groundGeom.getNativeAddr() || this.contact.getGeomID1() == this.pyramidGeom.getNativeAddr() || this.contact.getGeomID2() == this.pyramidGeom.getNativeAddr() || this.contact.getGeomID2() != this.sphere1.getGeom().getNativeAddr()) continue;
            this.contact.getPosition(pos);
            this.contact.getNormal(normal);
            this.contact.setMode(Ode.dContactBounce | Ode.dContactApprox1);
            this.contact.setBounce(1.8f);
            this.contact.setBounceVel(0.2f);
            this.contact.setMu(0.0f);
            System.err.println("A: " + i + " Sphere hits geom " + this.contact.getGeomID2() + "\n  d=" + this.contact.getDepth() + "\n  pos=" + pos + "\n  normal=" + normal);
        }
    }

    public void cleanup() {
        this.space.delete();
        this.collision.delete();
        this.world.delete();
        Ode.dCloseODE();
    }

    public List getGeoms() {
        return this.space.getGeoms();
    }

    public Geom getGeom(String name) {
        return this.space.getGeom(name);
    }

    public void resetSimulation() {
        this.box.setPosition(0.0f + (float)Math.random(), 0.0f + (float)Math.random(), 20.0f + (float)Math.random() * 5.0f);
        this.box.resetRotationAndForces();
        this.sphere1.setPosition(0.0f + (float)Math.random(), 0.0f + (float)Math.random(), 30.0f);
        this.sphere1.resetRotationAndForces();
        this.sphere2.setPosition(1.0f + (float)Math.random(), 5.0f + (float)Math.random(), 25.0f);
        this.sphere2.resetRotationAndForces();
        this.sphere3.setPosition(2.0f + (float)Math.random(), (float)Math.random(), 25.0f);
        this.sphere3.resetRotationAndForces();
        this.sphere4.setPosition(3.0f + (float)Math.random(), (float)Math.random(), 35.0f);
    }
}

