/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.test.simple;

import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dBodyID;
import org.odejava.ode.SWIGTYPE_p_dGeomID;
import org.odejava.ode.SWIGTYPE_p_dJointGroupID;
import org.odejava.ode.SWIGTYPE_p_dMass;
import org.odejava.ode.SWIGTYPE_p_dSpaceID;
import org.odejava.ode.SWIGTYPE_p_dWorldID;
import org.odejava.ode.SWIGTYPE_p_float;
import org.odejava.ode.dMass;

public class LowLevelApiExample {
    SWIGTYPE_p_dWorldID worldId;
    SWIGTYPE_p_dSpaceID spaceId;
    SWIGTYPE_p_dJointGroupID contactGroupId;
    SWIGTYPE_p_dBodyID boxBodyId;
    SWIGTYPE_p_dBodyID sphereBodyId;
    SWIGTYPE_p_dMass boxMass;
    SWIGTYPE_p_dMass sphereMass;
    SWIGTYPE_p_dGeomID boxGeomId;
    SWIGTYPE_p_dGeomID sphereGeomId;
    SWIGTYPE_p_float tmpFloatArray;

    public static void main(String[] args) {
        LowLevelApiExample simple = new LowLevelApiExample();
        simple.cleanup();
    }

    public LowLevelApiExample() {
        this.initWorld();
        this.initStaticObjects();
        this.initObjects();
        this.simulate(1000);
    }

    private void initWorld() {
        this.worldId = Ode.dWorldCreate();
        this.spaceId = Ode.dSimpleSpaceCreate(Ode.getPARENTSPACEID_ZERO());
        this.contactGroupId = Ode.dJointGroupCreate(0);
        Ode.dWorldSetGravity(this.worldId, 0.0f, 0.0f, -0.2f);
        Ode.setWorldID(this.worldId);
        Ode.setContactGroupID(this.contactGroupId);
        Ode.setSurfaceMu(Float.MAX_VALUE);
    }

    private void initStaticObjects() {
        Ode.dCreatePlane(this.spaceId, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    private void initObjects() {
        this.sphereBodyId = Ode.dBodyCreate(this.worldId);
        Ode.dBodySetPosition(this.sphereBodyId, 0.0f, 0.0f, 2.0f);
        dMass mass = new dMass();
        Ode.dMassSetSphere(mass.getCPtr(), 1.0f, 1.0f);
        Ode.dMassAdjust(mass.getCPtr(), 1.45f);
        Ode.dBodySetMass(this.sphereBodyId, mass.getCPtr());
        this.sphereGeomId = Ode.dCreateSphere(this.spaceId, 1.0f);
        Ode.dGeomSetBody(this.sphereGeomId, this.sphereBodyId);
        this.boxBodyId = Ode.dBodyCreate(this.worldId);
        Ode.dBodySetPosition(this.boxBodyId, 0.1f, 0.0f, 5.0f);
        dMass mass2 = new dMass();
        Ode.dMassSetBox(mass2.getCPtr(), 1.0f, 2.0f, 1.0f, 1.0f);
        Ode.dMassAdjust(mass2.getCPtr(), 1.0f);
        Ode.dBodySetMass(this.boxBodyId, mass2.getCPtr());
        this.boxGeomId = Ode.dCreateBox(this.spaceId, 2.0f, 1.0f, 1.0f);
        Ode.dGeomSetBody(this.boxGeomId, this.boxBodyId);
    }

    public void simulate(int steps) {
        int step = 0;
        while (step++ < steps) {
            this.step();
            if (step % 10 != 0) continue;
            System.out.println("Step " + step);
            System.out.print("  Box pos=" + this.getBodyPosition(this.boxBodyId));
            System.out.println(", quaternion=" + this.getBodyQuaternion(this.boxBodyId));
            System.out.print("  Sphere pos=" + this.getBodyPosition(this.sphereBodyId));
            System.out.println(", quaternion=" + this.getBodyQuaternion(this.sphereBodyId));
        }
    }

    public void step() {
        Ode.dWorldStepFast1(this.worldId, 0.05f, 10);
        Ode.dJointGroupEmpty(this.contactGroupId);
    }

    public Vector3f getBodyPosition(SWIGTYPE_p_dBodyID body) {
        this.tmpFloatArray = Ode.dBodyGetPosition(body);
        return new Vector3f(Ode.floatArray_getitem(this.tmpFloatArray, 0), Ode.floatArray_getitem(this.tmpFloatArray, 1), Ode.floatArray_getitem(this.tmpFloatArray, 2));
    }

    public Quat4f getBodyQuaternion(SWIGTYPE_p_dBodyID body) {
        this.tmpFloatArray = Ode.dBodyGetQuaternion(body);
        return new Quat4f(Ode.floatArray_getitem(this.tmpFloatArray, 1), Ode.floatArray_getitem(this.tmpFloatArray, 2), Ode.floatArray_getitem(this.tmpFloatArray, 3), Ode.floatArray_getitem(this.tmpFloatArray, 0));
    }

    public void cleanup() {
        Ode.dGeomDestroy(this.boxGeomId);
        Ode.dGeomDestroy(this.sphereGeomId);
        Ode.dJointGroupDestroy(this.contactGroupId);
        Ode.dSpaceDestroy(this.spaceId);
        Ode.dWorldDestroy(this.worldId);
        Ode.dCloseODE();
    }

    static {
        try {
            System.loadLibrary("odejava");
            System.out.println("Odejava library version " + Ode.ODEJAVA_VERSION + ".");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Native code library failed to load. " + e);
            System.exit(1);
        }
    }
}

