/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.test.simple;

import java.util.List;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.GeomBox;
import org.odejava.GeomPlane;
import org.odejava.GeomSphere;
import org.odejava.HashSpace;
import org.odejava.Odejava;
import org.odejava.World;
import org.odejava.collision.Contact;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.Ode;

public class HighLevelApiExample {
    World world;
    HashSpace space;
    Body sphere;
    Body box;
    JavaCollision collision;
    Contact contact;
    Vector3f fdir1 = new Vector3f();
    Vector3f pos = new Vector3f();
    Vector3f normal = new Vector3f();
    int boxId;
    int sphereId;
    int groundId;

    public static void main(String[] args) {
        HighLevelApiExample app = new HighLevelApiExample();
        app.simulate(1000);
        app.cleanup();
    }

    public HighLevelApiExample() {
        Odejava.getInstance();
        this.initWorld();
        this.collision = new JavaCollision(this.world);
        this.contact = new Contact(this.collision.getContactIntBuffer(), this.collision.getContactFloatBuffer());
        this.initEnvironment();
        this.initObjects();
    }

    private void initWorld() {
        this.world = new World();
        this.world.setGravity(0.0f, 0.0f, -0.2f);
        this.world.setStepInteractions(10);
        this.world.setStepSize(0.05f);
        this.space = new HashSpace();
    }

    private void initEnvironment() {
        GeomPlane groundGeom = new GeomPlane(0.0f, 0.0f, 1.0f, 0.0f);
        this.groundId = groundGeom.getNativeAddr();
        this.space.add(groundGeom);
    }

    private void initObjects() {
        this.sphere = new Body("sphere", this.world, new GeomSphere(1.0f));
        this.space.addBodyGeoms(this.sphere);
        this.sphere.setPosition(0.0f, 0.0f, 2.0f);
        this.sphere.adjustMass(1.0f);
        this.sphereId = this.sphere.getGeom().getNativeAddr();
        this.box = new Body("box", this.world, new GeomBox(2.0f, 1.0f, 1.0f));
        this.space.addBodyGeoms(this.box);
        this.box.setPosition(0.1f, 0.0f, 5.0f);
        this.box.adjustMass(1.0f);
        this.boxId = this.box.getGeom().getNativeAddr();
    }

    public void simulate(int steps) {
        int step = 0;
        while (step++ < steps) {
            this.step();
            if (step % 10 != 0) continue;
            System.out.println("Step " + step);
            System.out.print("  Box pos=" + this.box.getPosition());
            System.out.println(", quaternion=" + this.box.getQuaternion());
            System.out.print("  Sphere pos=" + this.world.getBody("sphere").getPosition());
            System.out.println(", quaternion=" + this.world.getBody("sphere").getQuaternion());
        }
    }

    public void step() {
        this.collision.collide(this.space);
        this.iterateContacts();
        this.collision.applyContacts();
        this.world.stepFast();
    }

    private void iterateContacts() {
        float depth = 0.0f;
        Vector3f pos = new Vector3f();
        Vector3f normal = new Vector3f();
        for (int i = 0; i < this.collision.getContactCount(); ++i) {
            this.contact.setIndex(i);
            if (this.contact.getGeomID1() == this.groundId || this.contact.getGeomID2() == this.groundId) continue;
            if (this.contact.getGeomID2() == this.sphereId) {
                this.contact.getPosition(pos);
                this.contact.getNormal(normal);
                this.contact.setMode(Ode.dContactBounce | Ode.dContactApprox1);
                this.contact.setBounce(0.24f);
                this.contact.setBounceVel(0.2f);
                this.contact.setMu(0.0f);
                System.err.println("A: " + i + " Sphere hits geom " + this.contact.getGeomID2() + "\n  d=" + this.contact.getDepth() + "\n  pos=" + pos + "\n  normal=" + normal);
            }
            if (this.contact.getGeomID2() != this.boxId) continue;
            this.contact.getPosition(pos);
            this.contact.getNormal(normal);
            this.contact.setMode(Ode.dContactBounce | Ode.dContactApprox1);
            this.contact.setBounce(1.25f);
            this.contact.setBounceVel(0.2f);
            this.contact.setMu(0.0f);
            System.err.println("B: " + i + " Box hits geom " + this.contact.getGeomID1() + "\n  d=" + this.contact.getDepth() + "\n  pos=" + pos + "\n  normal=" + normal);
        }
    }

    public void cleanup() {
        this.space.delete();
        this.collision.delete();
        this.world.delete();
        Ode.dCloseODE();
    }

    public List getGeoms() {
        return this.space.getGeoms();
    }

    public void resetSimulation() {
        this.sphere.setPosition(0.0f, 0.0f, 2.0f);
        this.sphere.resetRotationAndForces();
        this.box.setPosition(0.1f, 0.0f, 5.0f);
        this.box.resetRotationAndForces();
    }
}

