/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.test.car;

import java.util.Iterator;
import java.util.List;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.GeomBox;
import org.odejava.GeomPlane;
import org.odejava.GeomSphere;
import org.odejava.HashSpace;
import org.odejava.JointGroup;
import org.odejava.JointHinge2;
import org.odejava.World;
import org.odejava.collision.Contact;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.Ode;

public class Car {
    boolean inStep = false;
    World world;
    HashSpace space;
    JointGroup jointGroup;
    JointHinge2 hingeFrontLeft;
    JointHinge2 hingeFrontRight;
    JointHinge2 hingeBackLeft;
    JointHinge2 hingeBackRight;
    Vector3f gravity = new Vector3f(0.0f, 0.0f, -9.81f);
    Vector4f groundv = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    float carDensity = 1.0f;
    float wheelLength = 1.0f;
    float wheelRadius = 3.8f;
    float chassisSizeX = 20.0f;
    float chassisSizeY = 30.0f;
    float chassisSizeZ = 1.5f;
    float wheelChassisDistance = 0.1f;
    float chassisMass = 1.5f;
    float wheelMass = 0.125f;
    float suspensionErp = 0.8f;
    float suspensionCfm = 0.08f;
    float speed = 0.0f;
    float maxSpeed = 12.0f;
    float minSpeed = -5.0f;
    boolean handbrake = false;
    float steering = 0.0f;
    float steeringLimit = 0.2617994f;
    float steeringDeadzone = 0.015f;
    int boxCount = 20;
    float boxMass = 0.1f;
    int sphereCount = 20;
    float sphereRadius = 5.0f;
    float sphereMass = 0.01f;
    JavaCollision collision;
    Contact contact;
    Vector3f fdir1 = new Vector3f();
    Vector3f pos = new Vector3f();
    Vector3f normal = new Vector3f();
    int groundId;
    int chassisId;
    int wheelFLId;
    int wheelFRId;
    int wheelBLId;
    int wheelBRId;

    public Car() {
        this.initWorld();
        this.initObjects();
        this.setSimulation();
    }

    private void initWorld() {
        System.loadLibrary("odejava");
        System.out.println("Odejava version " + Ode.ODEJAVA_VERSION);
        this.world = new World();
        this.world.setGravity(this.gravity.x, this.gravity.y, this.gravity.z);
        this.collision = new JavaCollision(this.world);
        this.contact = new Contact(this.collision.getContactIntBuffer(), this.collision.getContactFloatBuffer());
        this.collision.setSurfaceMu(1000.0f);
        this.collision.setSurfaceBounce(0.14f);
        this.collision.setSurfaceBounceVel(0.1f);
        this.collision.setSurfaceMode(Ode.dContactBounce | Ode.dContactApprox1);
        this.world.setStepInteractions(10);
        this.world.setStepSize(0.05f);
        this.space = new HashSpace();
        this.jointGroup = new JointGroup();
        this.initStaticObjects();
    }

    private void initStaticObjects() {
        this.createRamps();
        GeomPlane groundGeom = new GeomPlane("ground", this.groundv.x, this.groundv.y, this.groundv.z, this.groundv.w);
        this.groundId = groundGeom.getNativeAddr();
        this.space.addGeom(groundGeom);
    }

    private void createRamps() {
        GeomBox g = new GeomBox("ramp", 80.0f, 32.0f, 2.0f);
        g.setPosition(new Vector3f(0.0f, 0.0f, 20.0f));
        this.space.addGeom(g);
        g = new GeomBox("ramp", 80.0f, 130.0f, 15.0f);
        g.setPosition(new Vector3f(0.0f, 80.0f, 0.0f));
        g.setAxisAndAngle(1.0f, 0.0f, 0.0f, 2.8274333f);
        this.space.addGeom(g);
        g = new GeomBox("ramp", 80.0f, 130.0f, 15.0f);
        g.setPosition(new Vector3f(0.0f, -80.0f, 0.0f));
        g.setAxisAndAngle(1.0f, 0.0f, 0.0f, -2.8274333f);
        this.space.addGeom(g);
        g = new GeomBox("ramp", 80.0f, 130.0f, 15.0f);
        g.setPosition(new Vector3f(-150.0f, 70.0f, 0.0f));
        g.setAxisAndAngle(1.0f, 0.0f, 0.0f, 2.8274333f);
        this.space.addGeom(g);
        g = new GeomBox("ramp", 80.0f, 130.0f, 15.0f);
        g.setPosition(new Vector3f(-150.0f, -70.0f, 0.0f));
        g.setAxisAndAngle(1.0f, 0.0f, 0.0f, -2.8274333f);
        this.space.addGeom(g);
        g = new GeomBox("ramp", 80.0f, 130.0f, 15.0f);
        g.setPosition(new Vector3f(150.0f, 125.0f, 0.0f));
        g.setAxisAndAngle(1.0f, 0.0f, 0.0f, 2.8274333f);
        this.space.addGeom(g);
        g = new GeomBox("ramp", 80.0f, 130.0f, 15.0f);
        g.setPosition(new Vector3f(150.0f, -125.0f, 0.0f));
        g.setAxisAndAngle(1.0f, 0.0f, 0.0f, -2.8274333f);
        this.space.addGeom(g);
    }

    private void initObjects() {
        this.initCar();
        this.initBoxesAndSpheres();
    }

    private void initCar() {
        Body b = new Body("wheelFrontLeft", this.world, new GeomSphere(this.wheelRadius));
        b.adjustMass(this.wheelMass);
        this.wheelFLId = b.getGeom().getNativeAddr();
        this.space.addBodyGeoms(b);
        b = new Body("wheelFrontRight", this.world, new GeomSphere(this.wheelRadius));
        b.adjustMass(this.wheelMass);
        this.wheelFRId = b.getGeom().getNativeAddr();
        this.space.addBodyGeoms(b);
        b = new Body("wheelBackLeft", this.world, new GeomSphere(this.wheelRadius));
        b.adjustMass(this.wheelMass);
        this.wheelBLId = b.getGeom().getNativeAddr();
        this.space.addBodyGeoms(b);
        b = new Body("wheelBackRight", this.world, new GeomSphere(this.wheelRadius));
        b.adjustMass(this.wheelMass);
        this.wheelBRId = b.getGeom().getNativeAddr();
        this.space.addBodyGeoms(b);
        b = new Body("chassis", this.world, new GeomBox(this.chassisSizeX, this.chassisSizeY, this.chassisSizeZ));
        b.adjustMass(this.chassisMass);
        this.space.addBodyGeoms(b);
        this.chassisId = b.getGeom().getNativeAddr();
    }

    private void initBoxesAndSpheres() {
        Body b;
        int i;
        for (i = 0; i < this.boxCount; ++i) {
            b = new Body("box" + i, this.world, new GeomBox(15.0f, 8.0f, 5.0f));
            b.adjustMass(this.boxMass);
            this.space.addBodyGeoms(b);
        }
        for (i = 0; i < this.sphereCount; ++i) {
            b = new Body("sphere" + i, this.world, new GeomSphere(this.sphereRadius));
            b.adjustMass(this.sphereMass);
            this.space.addBodyGeoms(b);
        }
    }

    public void setSimulation() {
        int i;
        Body b;
        float curX = 0.0f;
        float curY = 0.0f;
        float curZ = 0.0f;
        this.steering = 0.0f;
        this.speed = 0.0f;
        Iterator bodiesIterator = this.world.getBodies().iterator();
        while (bodiesIterator.hasNext()) {
            b = (Body)bodiesIterator.next();
            b.resetRotationAndForces();
        }
        curZ = 40.0f;
        this.world.getBody("chassis").setPosition(curX, curY -= 50.0f, curZ);
        this.world.getBody("wheelFrontLeft").setPosition(curX - this.chassisSizeX / 2.0f - this.wheelRadius - this.wheelChassisDistance, curY + this.chassisSizeY / 2.0f, curZ);
        this.world.getBody("wheelFrontRight").setPosition(curX + this.chassisSizeX / 2.0f + this.wheelRadius + this.wheelChassisDistance, curY + this.chassisSizeY / 2.0f, curZ);
        this.world.getBody("wheelBackLeft").setPosition(curX - this.chassisSizeX / 2.0f - this.wheelRadius - this.wheelChassisDistance, curY - this.chassisSizeY / 2.0f, curZ);
        this.world.getBody("wheelBackRight").setPosition(curX + this.chassisSizeX / 2.0f + this.wheelRadius + this.wheelChassisDistance, curY - this.chassisSizeY / 2.0f, curZ);
        this.jointGroup.empty();
        this.hingeFrontLeft = new JointHinge2("hingeFrontLeft", this.world, this.jointGroup);
        this.hingeFrontLeft.attach(this.world.getBody("chassis"), this.world.getBody("wheelFrontLeft"));
        this.hingeFrontLeft.setAnchor(curX - this.chassisSizeX / 2.0f - this.wheelRadius - this.wheelChassisDistance, curY + this.chassisSizeY / 2.0f, curZ);
        this.hingeFrontRight = new JointHinge2("hingeFrontRight", this.world, this.jointGroup);
        this.hingeFrontRight.attach(this.world.getBody("chassis"), this.world.getBody("wheelFrontRight"));
        this.hingeFrontRight.setAnchor(curX + this.chassisSizeX / 2.0f + this.wheelRadius + this.wheelChassisDistance, curY + this.chassisSizeY / 2.0f, curZ);
        this.hingeBackLeft = new JointHinge2("hingeBackLeft", this.world, this.jointGroup);
        this.hingeBackLeft.attach(this.world.getBody("chassis"), this.world.getBody("wheelBackLeft"));
        this.hingeBackLeft.setAnchor(curX - this.chassisSizeX / 2.0f - this.wheelRadius - this.wheelChassisDistance, curY - this.chassisSizeY / 2.0f, curZ);
        this.hingeBackRight = new JointHinge2("hingeBackRight", this.world, this.jointGroup);
        this.hingeBackRight.attach(this.world.getBody("chassis"), this.world.getBody("wheelBackRight"));
        this.hingeBackRight.setAnchor(curX + this.chassisSizeX / 2.0f + this.wheelRadius + this.wheelChassisDistance, curY - this.chassisSizeY / 2.0f, curZ);
        Iterator iter = this.jointGroup.getJointList().iterator();
        while (iter.hasNext()) {
            JointHinge2 joint = (JointHinge2)iter.next();
            joint.setAxis1(0.0f, 0.0f, 1.0f);
            joint.setAxis2(1.0f, 0.0f, 0.0f);
            joint.setParam(Ode.dParamSuspensionERP, this.suspensionErp);
            joint.setParam(Ode.dParamSuspensionCFM, this.suspensionCfm);
            joint.setParam(Ode.dParamLoStop, 0.0f);
            joint.setParam(Ode.dParamHiStop, 0.0f);
            joint.setParam(Ode.dParamFMax, 100.0f);
            joint.setParam(Ode.dParamVel2, 0.0f);
            joint.setParam(Ode.dParamFMax2, 500.0f);
        }
        float rampMiddleHeight = 20.0f;
        curY = -12.0f;
        curX = -9.0f;
        curZ = rampMiddleHeight;
        int j = 0;
        float previousBoxSizeZ = 0.0f;
        for (i = 0; i < this.boxCount; ++i) {
            b = this.world.getBody("box" + i);
            float[] boxSize = ((GeomBox)b.getGeom()).getLengths();
            if (i > 5) {
                if (j % 10 == 0) {
                    curX = -9.0f;
                    curY += boxSize[1];
                    curZ = rampMiddleHeight;
                } else if (j % 5 == 0) {
                    curX += boxSize[0];
                    curZ = rampMiddleHeight;
                } else {
                    curZ += previousBoxSizeZ / 2.0f;
                }
            }
            b.setPosition(curX, curY, curZ += boxSize[2] / 2.0f);
            previousBoxSizeZ = boxSize[2];
            ++j;
        }
        for (i = 0; i < this.sphereCount; ++i) {
            b = this.world.getBody("sphere" + i);
            b.setPosition(i * 10, -150 + i * 10, 2.5f);
        }
    }

    public void step() {
        this.inStep = true;
        this.updateEngine();
        this.updateSteering();
        this.collision.collide(this.space);
        this.iterateContacts();
        this.collision.applyContacts();
        this.world.quickStep();
        this.inStep = false;
    }

    private void iterateContacts() {
        float depth = 0.0f;
        Vector3f pos = new Vector3f();
        Vector3f normal = new Vector3f();
        for (int i = 0; i < this.collision.getContactCount(); ++i) {
            this.contact.setIndex(i);
            if (this.contact.getGeomID1() == this.groundId || this.contact.getGeomID2() == this.groundId) continue;
            if (this.contact.getGeomID1() == this.chassisId) {
                this.contact.getPosition(pos);
                this.contact.getNormal(normal);
                this.contact.setMode(Ode.dContactBounce | Ode.dContactApprox1);
                this.contact.setBounce(1.25f);
                this.contact.setBounceVel(0.2f);
                this.contact.setMu(0.0f);
                System.err.println("A: " + i + " Chassis hits geom " + this.contact.getGeomID2() + "\n  d=" + this.contact.getDepth() + "\n  pos=" + pos + "\n  normal=" + normal);
            }
            if (this.contact.getGeomID2() == this.chassisId) {
                this.contact.getPosition(pos);
                this.contact.getNormal(normal);
                this.contact.setMode(Ode.dContactBounce | Ode.dContactApprox1);
                this.contact.setBounce(0.24f);
                this.contact.setBounceVel(0.2f);
                this.contact.setMu(0.0f);
                System.err.println("B: " + i + " Chassis got hit by geom " + this.contact.getGeomID1() + "\n  d=" + this.contact.getDepth() + "\n  pos=" + pos + "\n  normal=" + normal);
            }
            if (this.contact.getGeomID2() != this.wheelFLId && this.contact.getGeomID2() != this.wheelFRId && this.contact.getGeomID2() != this.wheelBLId && this.contact.getGeomID2() != this.wheelBRId) continue;
            this.contact.getPosition(pos);
            this.contact.getNormal(normal);
            this.contact.setMode(Ode.dContactBounce | Ode.dContactApprox1 | Ode.dContactSoftCFM | Ode.dContactSoftERP);
            this.contact.setSoftCfm(1.0f);
            this.contact.setSoftErp(1.0E-6f);
            this.contact.setBounce(1.25f);
            this.contact.setBounceVel(0.2f);
            this.contact.setMu(0.0f);
            System.err.println("C: " + i + " Wheel hits geom " + this.contact.getGeomID1() + "\n  d=" + this.contact.getDepth() + "\n  pos=" + pos + "\n  normal=" + normal);
        }
    }

    private void updateEngine() {
        if (this.handbrake) {
            this.hingeBackLeft.setParam(Ode.dParamVel2, 0.0f);
            this.hingeBackRight.setParam(Ode.dParamVel2, 0.0f);
        } else {
            this.hingeBackLeft.setParam(Ode.dParamVel2, this.speed);
            this.hingeBackRight.setParam(Ode.dParamVel2, this.speed);
        }
        this.hingeFrontLeft.setParam(Ode.dParamVel2, this.speed);
        this.hingeFrontRight.setParam(Ode.dParamVel2, this.speed);
    }

    private void updateSteering() {
        if (this.steering > -this.steeringDeadzone && this.steering < this.steeringDeadzone) {
            this.hingeFrontLeft.setParam(Ode.dParamLoStop, 0.0f);
            this.hingeFrontLeft.setParam(Ode.dParamHiStop, 0.0f);
            this.hingeFrontRight.setParam(Ode.dParamLoStop, 0.0f);
            this.hingeFrontRight.setParam(Ode.dParamHiStop, 0.0f);
        } else if (this.steering > 0.0f) {
            this.hingeFrontLeft.setParam(Ode.dParamLoStop, (float)((double)(this.steering * 3.0f) - 0.02));
            this.hingeFrontLeft.setParam(Ode.dParamHiStop, (float)((double)(this.steering * 3.0f) + 0.02));
            this.hingeFrontRight.setParam(Ode.dParamLoStop, (float)((double)(this.steering * 3.0f) - 0.02));
            this.hingeFrontRight.setParam(Ode.dParamHiStop, (float)((double)(this.steering * 3.0f) + 0.02));
        } else {
            this.hingeFrontLeft.setParam(Ode.dParamLoStop, (float)((double)(this.steering * 3.0f) - 0.02));
            this.hingeFrontLeft.setParam(Ode.dParamHiStop, (float)((double)(this.steering * 3.0f) + 0.02));
            this.hingeFrontRight.setParam(Ode.dParamLoStop, (float)((double)(this.steering * 3.0f) - 0.02));
            this.hingeFrontRight.setParam(Ode.dParamHiStop, (float)((double)(this.steering * 3.0f) + 0.02));
        }
    }

    public Vector3f getGravity() {
        return this.gravity;
    }

    public void setGravity(Vector3f gravity) {
        this.gravity = gravity;
        this.world.setGravity(gravity.x, gravity.y, gravity.z);
    }

    public void accelerate(float force) {
        this.speed = this.speed > 0.0f ? (this.speed += (this.speed + 0.5f) * force) : (this.speed -= (this.speed - 0.5f) * force);
        if (this.speed > this.maxSpeed) {
            this.speed = this.maxSpeed;
        } else if (this.speed < this.minSpeed) {
            this.speed = this.minSpeed;
        }
    }

    public void steer(float steer) {
        this.steering += steer;
        if (this.steering < -this.steeringLimit) {
            this.steering = -this.steeringLimit;
        } else if (this.steering > this.steeringLimit) {
            this.steering = this.steeringLimit;
        }
    }

    public void rotateObjects(float x, float y, float z) {
        Iterator i = this.world.getBodies().iterator();
        while (i.hasNext()) {
            ((Body)i.next()).addForce(x, y, 15.0f * z + 10.0f);
        }
    }

    public void applyForceToCar(float z) {
        this.world.getBody("chassis").addForce(0.0f, 0.0f, 600.0f * z);
    }

    public void cleanup() {
        while (this.inStep) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.jointGroup.delete();
        this.space.delete();
        this.collision.delete();
        this.world.delete();
        Ode.dCloseODE();
    }

    public boolean isHandbrake() {
        return this.handbrake;
    }

    public void setHandbrake(boolean handbrake) {
        this.handbrake = handbrake;
        System.out.println("Handbrake is " + handbrake);
    }

    public List getBodies() {
        return this.world.getBodies();
    }

    public Body getBody(String name) {
        return this.world.getBody(name);
    }

    public List getGeoms() {
        return this.space.getGeoms();
    }

    public Geom getGeom(String name) {
        return this.space.getGeom(name);
    }

    public int getBoxCount() {
        return this.boxCount;
    }
}

