/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.display;

import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.Placeable;
import org.odejava.display.DisplayTransformable;

public class BoundDisplayObject {
    private boolean updateNeeded = true;
    protected DisplayTransformable displayObject;
    protected Placeable odeObject;
    private Vector3f positionCache = new Vector3f();
    private Quat4f rotationCache = new Quat4f();
    private Vector3f prevPosition = new Vector3f();
    private Quat4f prevRotation = new Quat4f();

    public BoundDisplayObject(DisplayTransformable displayObject, Placeable odeObject) {
        if (displayObject == null) {
            throw new IllegalArgumentException("Display object cannot be null");
        }
        if (odeObject == null) {
            throw new IllegalArgumentException("Display object cannot be null");
        }
        this.displayObject = displayObject;
        this.odeObject = odeObject;
    }

    public void update() {
        if (this.updateNeeded) {
            this.odeObject.getPosition(this.positionCache);
            this.odeObject.getQuaternion(this.rotationCache);
            if (!this.prevPosition.equals(this.positionCache) || !this.prevRotation.equals(this.rotationCache)) {
                this.displayObject.setTransform(this.odeObject.getPosition(this.positionCache), this.odeObject.getQuaternion(this.rotationCache));
                if (this.odeObject.fixed()) {
                    this.updateNeeded = false;
                }
                this.prevPosition.set(this.positionCache);
                this.prevRotation.set(this.rotationCache);
            }
        }
    }

    public DisplayTransformable getDisplayTransformable() {
        return this.displayObject;
    }

    public void setDisplayTransformable(DisplayTransformable displayObject) {
        this.displayObject = displayObject;
        this.forceUpdate();
    }

    public Placeable getOdeTransformable() {
        return this.odeObject;
    }

    public void setOdeTransformable(Placeable odeObject) {
        this.odeObject = odeObject;
        this.forceUpdate();
    }

    public void forceUpdate() {
        this.updateNeeded = true;
        this.prevPosition.x = 0.0f;
        this.prevPosition.y = 0.0f;
        this.prevPosition.z = 0.0f;
        this.prevRotation.w = 0.0f;
        this.prevRotation.x = 0.0f;
        this.prevRotation.y = 0.0f;
        this.prevRotation.z = 0.0f;
    }
}

