/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.collision;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.collision.Collision;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dWorldID;

public class JavaCollision
extends Collision {
    private static final String VALID_WORLD_REQ_ERR = "A valid world reference is required to construct an instance of this class.";
    private int contactCount;
    private ByteBuffer contactBuffer1;
    private IntBuffer contactIntBuffer;
    private ByteBuffer contactBuffer2;
    private FloatBuffer contactFloatBuffer;
    private SWIGTYPE_p_dWorldID worldId;

    private native void setMaxStepContacts(int var1);

    private native int spaceCollide(long var1);

    private native int spaceCollide2(int var1, int var2);

    private native void createContactJoints();

    private native ByteBuffer getContactIntBuf();

    private native ByteBuffer getContactFloatBuf();

    public JavaCollision(World world) {
        if (world == null) {
            throw new NullPointerException(VALID_WORLD_REQ_ERR);
        }
        this.worldId = world.getId();
        this.contactBuffer1 = this.getContactIntBuf();
        this.contactBuffer1.order(ByteOrder.nativeOrder());
        this.contactIntBuffer = this.contactBuffer1.asIntBuffer();
        this.contactBuffer2 = this.getContactFloatBuf();
        this.contactBuffer2.order(ByteOrder.nativeOrder());
        this.contactFloatBuffer = this.contactBuffer2.asFloatBuffer();
    }

    public void setMaxStepContactsPerNearcallback(int size) {
        this.setMaxStepContacts(size);
    }

    public void collide(Space space) {
        if (this.deleted) {
            return;
        }
        this.contactIntBuffer.rewind();
        this.contactFloatBuffer.rewind();
        Ode.setContactGroupID(this.contactGroupId);
        Ode.setWorldID(this.worldId);
        this.emptyContactGroup();
        this.contactCount = this.spaceCollide(space.getId().getSwigCPtr());
    }

    public void collide2(int o1, int o2) {
        if (this.deleted) {
            return;
        }
        this.contactIntBuffer.rewind();
        this.contactFloatBuffer.rewind();
        Ode.setContactGroupID(this.contactGroupId);
        Ode.setWorldID(this.worldId);
        this.emptyContactGroup();
        this.spaceCollide2(o1, o2);
    }

    public void applyContacts() {
        if (this.deleted) {
            return;
        }
        this.contactIntBuffer.rewind();
        this.contactFloatBuffer.rewind();
        Ode.setContactGroupID(this.contactGroupId);
        Ode.setWorldID(this.worldId);
        if (this.contactCount > 0) {
            this.createContactJoints();
        }
    }

    public int getContactCount() {
        return this.contactCount;
    }

    public IntBuffer getContactIntBuffer() {
        return this.contactIntBuffer;
    }

    public FloatBuffer getContactFloatBuffer() {
        return this.contactFloatBuffer;
    }
}

