/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.collision;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Vector3f;
import org.odejava.Geom;

public class Contact {
    private static final String MAX_INDEX_MSG = "Index is past the end of the maximum number of held contacts";
    public static final int INTBUF_CHUNK_SIZE = 5;
    public static final int GEOM_ID1 = 0;
    public static final int GEOM_ID2 = 1;
    public static final int BODY_ID1 = 2;
    public static final int BODY_ID2 = 3;
    public static final int MODE = 4;
    public static final int FLOATBUF_CHUNK_SIZE = 20;
    public static final int POSITION = 0;
    public static final int NORMAL = 3;
    public static final int DEPTH = 6;
    public static final int FDIR1 = 7;
    public static final int MU = 10;
    public static final int MU2 = 11;
    public static final int BOUNCE = 12;
    public static final int BOUNCE_VEL = 13;
    public static final int SOFT_ERP = 14;
    public static final int SOFT_CFM = 15;
    public static final int MOTION1 = 16;
    public static final int MOTION2 = 17;
    public static final int SLIP1 = 18;
    public static final int SLIP2 = 19;
    protected IntBuffer intBuf;
    protected FloatBuffer floatBuf;
    protected int index;
    protected int maxContacts;

    public Contact(IntBuffer intBuf, FloatBuffer floatBuf) {
        this.intBuf = intBuf;
        this.floatBuf = floatBuf;
        this.index = 0;
        this.maxContacts = intBuf.capacity() / 5;
    }

    public void setIndex(int index) {
        if (index >= this.maxContacts) {
            throw new ArrayIndexOutOfBoundsException(MAX_INDEX_MSG);
        }
        this.index = index;
    }

    public void nextContact() {
        if (this.index + 1 >= this.maxContacts) {
            throw new ArrayIndexOutOfBoundsException(MAX_INDEX_MSG);
        }
        ++this.index;
    }

    public int getMaxContacts() {
        return this.maxContacts;
    }

    public void ignoreContact() {
        this.setGeomID1(0);
        this.setGeomID2(0);
    }

    public int getGeomID1() {
        return this.intBuf.get(this.index * 5 + 0);
    }

    public int getGeomID1(int idx) {
        return this.intBuf.get(this.index * 5 + 0);
    }

    public Geom getGeom1() {
        return Geom.getGeomFromNativeAddr(this.getGeomID1());
    }

    public Geom getGeom1(int idx) {
        return Geom.getGeomFromNativeAddr(this.getGeomID1());
    }

    public void setGeomID1(int id) {
        this.intBuf.put(this.index * 5 + 0, id);
    }

    public void setGeomID1(int id, int idx) {
        this.intBuf.put(idx * 5 + 0, id);
    }

    public int getGeomID2() {
        return this.intBuf.get(this.index * 5 + 1);
    }

    public int getGeomID2(int idx) {
        return this.intBuf.get(idx * 5 + 1);
    }

    public Geom getGeom2() {
        return Geom.getGeomFromNativeAddr(this.getGeomID2());
    }

    public Geom getGeom2(int idx) {
        return Geom.getGeomFromNativeAddr(this.getGeomID2());
    }

    public boolean geom1EqualTo(Geom geom) {
        return geom.getNativeAddr() == this.getGeomID1();
    }

    public boolean geom2EqualTo(Geom geom) {
        return geom.getNativeAddr() == this.getGeomID2();
    }

    public void setGeomID2(int id) {
        this.intBuf.put(this.index * 5 + 1, id);
    }

    public void setGeomID2(int id, int idx) {
        this.intBuf.put(idx * 5 + 1, id);
    }

    public int getBodyID1() {
        return this.intBuf.get(this.index * 5 + 2);
    }

    public int getBodyID1(int idx) {
        return this.intBuf.get(idx * 5 + 2);
    }

    public void setBodyID1(int id) {
        this.intBuf.put(this.index * 5 + 2, id);
    }

    public void setBodyID1(int id, int idx) {
        this.intBuf.put(idx * 5 + 2, id);
    }

    public int getBodyID2() {
        return this.intBuf.get(this.index * 5 + 3);
    }

    public int getBodyID2(int idx) {
        return this.intBuf.get(idx * 5 + 3);
    }

    public void setBodyID2(int id) {
        this.intBuf.put(this.index * 5 + 3, id);
    }

    public void setBodyID2(int id, int idx) {
        this.intBuf.put(idx * 5 + 3, id);
    }

    public int getMode() {
        return this.intBuf.get(this.index * 5 + 4);
    }

    public int getMode(int idx) {
        return this.intBuf.get(idx * 5 + 4);
    }

    public void setMode(int mode) {
        this.intBuf.put(this.index * 5 + 4, mode);
    }

    public void setMode(int mode, int idx) {
        this.intBuf.put(idx * 5 + 4, mode);
    }

    public void getPosition(Vector3f position) {
        position.x = this.floatBuf.get(this.index * 20 + 0);
        position.y = this.floatBuf.get(this.index * 20 + 0 + 1);
        position.z = this.floatBuf.get(this.index * 20 + 0 + 2);
    }

    public void getPosition(Vector3f position, int idx) {
        position.x = this.floatBuf.get(idx * 20 + 0);
        position.y = this.floatBuf.get(idx * 20 + 0 + 1);
        position.z = this.floatBuf.get(idx * 20 + 0 + 2);
    }

    public void getPosition(float[] position) {
        position[0] = this.floatBuf.get(this.index * 20 + 0);
        position[1] = this.floatBuf.get(this.index * 20 + 0 + 1);
        position[2] = this.floatBuf.get(this.index * 20 + 0 + 2);
    }

    public void getPosition(float[] position, int idx) {
        position[0] = this.floatBuf.get(idx * 20 + 0);
        position[1] = this.floatBuf.get(idx * 20 + 0 + 1);
        position[2] = this.floatBuf.get(idx * 20 + 0 + 2);
    }

    public float[] getPosition() {
        float[] position = new float[]{this.floatBuf.get(this.index * 20 + 0), this.floatBuf.get(this.index * 20 + 0 + 1), this.floatBuf.get(this.index * 20 + 0 + 2)};
        return position;
    }

    public float[] getPosition(int idx) {
        float[] position = new float[]{this.floatBuf.get(idx * 20 + 0), this.floatBuf.get(idx * 20 + 0 + 1), this.floatBuf.get(idx * 20 + 0 + 2)};
        return position;
    }

    public void setPosition(float[] position) {
        this.floatBuf.put(this.index * 20 + 0, position[0]);
        this.floatBuf.put(this.index * 20 + 0 + 1, position[1]);
        this.floatBuf.put(this.index * 20 + 0 + 2, position[2]);
    }

    public void setPosition(float[] position, int idx) {
        this.floatBuf.put(idx * 20 + 0, position[0]);
        this.floatBuf.put(idx * 20 + 0 + 1, position[1]);
        this.floatBuf.put(idx * 20 + 0 + 2, position[2]);
    }

    public void getNormal(Vector3f normal) {
        normal.x = this.floatBuf.get(this.index * 20 + 3);
        normal.y = this.floatBuf.get(this.index * 20 + 3 + 1);
        normal.z = this.floatBuf.get(this.index * 20 + 3 + 2);
    }

    public void getNormal(Vector3f normal, int idx) {
        normal.x = this.floatBuf.get(idx * 20 + 3);
        normal.y = this.floatBuf.get(idx * 20 + 3 + 1);
        normal.z = this.floatBuf.get(idx * 20 + 3 + 2);
    }

    public void getNormal(float[] normal) {
        normal[0] = this.floatBuf.get(this.index * 20 + 3);
        normal[1] = this.floatBuf.get(this.index * 20 + 3 + 1);
        normal[2] = this.floatBuf.get(this.index * 20 + 3 + 2);
    }

    public void getNormal(float[] normal, int idx) {
        normal[0] = this.floatBuf.get(idx * 20 + 3);
        normal[1] = this.floatBuf.get(idx * 20 + 3 + 1);
        normal[2] = this.floatBuf.get(idx * 20 + 3 + 2);
    }

    public float[] getNormal() {
        float[] normal = new float[]{this.floatBuf.get(this.index * 20 + 3), this.floatBuf.get(this.index * 20 + 3 + 1), this.floatBuf.get(this.index * 20 + 3 + 2)};
        return normal;
    }

    public float[] getNormal(int idx) {
        float[] normal = new float[]{this.floatBuf.get(idx * 20 + 3), this.floatBuf.get(idx * 20 + 3 + 1), this.floatBuf.get(idx * 20 + 3 + 2)};
        return normal;
    }

    public void setNormal(float[] normal) {
        this.floatBuf.put(this.index * 20 + 3, normal[0]);
        this.floatBuf.put(this.index * 20 + 3 + 1, normal[1]);
        this.floatBuf.put(this.index * 20 + 3 + 2, normal[2]);
    }

    public void setNormal(float[] normal, int idx) {
        this.floatBuf.put(idx * 20 + 3, normal[0]);
        this.floatBuf.put(idx * 20 + 3 + 1, normal[1]);
        this.floatBuf.put(idx * 20 + 3 + 2, normal[2]);
    }

    public float getDepth() {
        return this.floatBuf.get(this.index * 20 + 6);
    }

    public float getDepth(int idx) {
        return this.floatBuf.get(idx * 20 + 6);
    }

    public void setDepth(float depth) {
        this.floatBuf.put(this.index * 20 + 6, depth);
    }

    public void setDepth(float depth, int idx) {
        this.floatBuf.put(idx * 20 + 6, depth);
    }

    public void getFdir1(float[] fdir1) {
        fdir1[0] = this.floatBuf.get(this.index * 20 + 7);
        fdir1[1] = this.floatBuf.get(this.index * 20 + 7 + 1);
        fdir1[2] = this.floatBuf.get(this.index * 20 + 7 + 2);
    }

    public void getFdir1(float[] fdir1, int idx) {
        fdir1[0] = this.floatBuf.get(idx * 20 + 7);
        fdir1[1] = this.floatBuf.get(idx * 20 + 7 + 1);
        fdir1[2] = this.floatBuf.get(idx * 20 + 7 + 2);
    }

    public void setFdir1(float[] fdir1) {
        this.floatBuf.put(this.index * 20 + 7, fdir1[0]);
        this.floatBuf.put(this.index * 20 + 7 + 1, fdir1[1]);
        this.floatBuf.put(this.index * 20 + 7 + 2, fdir1[2]);
    }

    public void setFdir1(float[] fdir1, int idx) {
        this.floatBuf.put(idx * 20 + 7, fdir1[0]);
        this.floatBuf.put(idx * 20 + 7 + 1, fdir1[1]);
        this.floatBuf.put(idx * 20 + 7 + 2, fdir1[2]);
    }

    public float getMu() {
        return this.floatBuf.get(this.index * 20 + 10);
    }

    public float getMu(int idx) {
        return this.floatBuf.get(idx * 20 + 10);
    }

    public void setMu(float mu) {
        this.floatBuf.put(this.index * 20 + 10, mu);
    }

    public void setMu(float mu, int idx) {
        this.floatBuf.put(idx * 20 + 10, mu);
    }

    public float getMu2() {
        return this.floatBuf.get(this.index * 20 + 11);
    }

    public float getMu2(int idx) {
        return this.floatBuf.get(idx * 20 + 11);
    }

    public void setMu2(float mu2) {
        this.floatBuf.put(this.index * 20 + 11, mu2);
    }

    public void setMu2(float mu2, int idx) {
        this.floatBuf.put(idx * 20 + 11, mu2);
    }

    public float getBounce() {
        return this.floatBuf.get(this.index * 20 + 12);
    }

    public float getBounce(int idx) {
        return this.floatBuf.get(idx * 20 + 12);
    }

    public void setBounce(float bounce) {
        this.floatBuf.put(this.index * 20 + 12, bounce);
    }

    public void setBounce(float bounce, int idx) {
        this.floatBuf.put(idx * 20 + 12, bounce);
    }

    public float getBounceVel() {
        return this.floatBuf.get(this.index * 20 + 13);
    }

    public float getBounceVel(int idx) {
        return this.floatBuf.get(idx * 20 + 13);
    }

    public void setBounceVel(float bounceVel) {
        this.floatBuf.put(this.index * 20 + 13, bounceVel);
    }

    public void setBounceVel(float bounceVel, int idx) {
        this.floatBuf.put(idx * 20 + 13, bounceVel);
    }

    public float getSoftErp() {
        return this.floatBuf.get(this.index * 20 + 14);
    }

    public float getSoftErp(int idx) {
        return this.floatBuf.get(idx * 20 + 14);
    }

    public void setSoftErp(float softErp) {
        this.floatBuf.put(this.index * 20 + 14, softErp);
    }

    public void setSoftErp(float softErp, int idx) {
        this.floatBuf.put(idx * 20 + 14, softErp);
    }

    public float getSoftCfm() {
        return this.floatBuf.get(this.index * 20 + 15);
    }

    public float getSoftCfm(int idx) {
        return this.floatBuf.get(idx * 20 + 15);
    }

    public void setSoftCfm(float softCfm) {
        this.floatBuf.put(this.index * 20 + 15, softCfm);
    }

    public void setSoftCfm(float softCfm, int idx) {
        this.floatBuf.put(idx * 20 + 15, softCfm);
    }

    public float getMotion1() {
        return this.floatBuf.get(this.index * 20 + 16);
    }

    public float getMotion1(int idx) {
        return this.floatBuf.get(idx * 20 + 16);
    }

    public void setMotion1(float motion1) {
        this.floatBuf.put(this.index * 20 + 16, motion1);
    }

    public void setMotion1(float motion1, int idx) {
        this.floatBuf.put(idx * 20 + 16, motion1);
    }

    public float getMotion2() {
        return this.floatBuf.get(this.index * 20 + 17);
    }

    public float getMotion2(int idx) {
        return this.floatBuf.get(idx * 20 + 17);
    }

    public void setMotion2(float motion2) {
        this.floatBuf.put(this.index * 20 + 17, motion2);
    }

    public void setMotion2(float motion2, int idx) {
        this.floatBuf.put(idx * 20 + 17, motion2);
    }

    public float getSlip1() {
        return this.floatBuf.get(this.index * 20 + 18);
    }

    public float getSlip1(int idx) {
        return this.floatBuf.get(idx * 20 + 18);
    }

    public void setSlip1(float slip1) {
        this.floatBuf.put(this.index * 20 + 18, slip1);
    }

    public void setSlip1(float slip1, int idx) {
        this.floatBuf.put(idx * 20 + 18, slip1);
    }

    public float getSlip2() {
        return this.floatBuf.get(this.index * 20 + 19);
    }

    public float getSlip2(int idx) {
        return this.floatBuf.get(idx * 20 + 19);
    }

    public void setSlip2(float slip2) {
        this.floatBuf.put(this.index * 20 + 19, slip2);
    }

    public void setSlip2(float slip2, int idx) {
        this.floatBuf.put(idx * 20 + 19, slip2);
    }
}

