/*
 * Decompiled with CFR 0.152.
 */
package org.odejava.collision;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Vector3f;
import org.odejava.collision.Contact;

public class BulkContact
extends Contact {
    int contactCount;
    public static final int ARRAY_SIZE = 1500;
    int[] intArray = new int[7500];
    float[] floatArray = new float[30000];

    public BulkContact(IntBuffer intBuf, FloatBuffer floatBuf) {
        super(intBuf, floatBuf);
    }

    public void load(int contactCount) {
        this.contactCount = contactCount;
        this.intBuf.rewind();
        this.floatBuf.rewind();
        this.intBuf.get(this.intArray, 0, 5 * contactCount);
        this.floatBuf.get(this.floatArray, 0, 20 * contactCount);
    }

    public void commit() {
        this.intBuf.rewind();
        this.floatBuf.rewind();
        this.intBuf.put(this.intArray, 0, 5 * this.contactCount);
        this.floatBuf.put(this.floatArray, 0, 20 * this.contactCount);
    }

    public void ignoreContact(int idx) {
        this.setGeomID1(0, idx);
        this.setGeomID2(0, idx);
    }

    public int getGeomID1() {
        return this.intArray[this.index * 5 + 0];
    }

    public int getGeomID1(int idx) {
        return this.intArray[idx * 5 + 0];
    }

    public void setGeomID1(int id) {
        this.intArray[this.index * 5 + 0] = id;
    }

    public void setGeomID1(int id, int idx) {
        this.intArray[idx * 5 + 0] = id;
    }

    public int getGeomID2() {
        return this.intArray[this.index * 5 + 1];
    }

    public int getGeomID2(int idx) {
        return this.intArray[idx * 5 + 1];
    }

    public void setGeomID2(int id) {
        this.intArray[this.index * 5 + 1] = id;
    }

    public void setGeomID2(int id, int idx) {
        this.intArray[idx * 5 + 1] = id;
    }

    public int getBodyID1() {
        return this.intArray[this.index * 5 + 2];
    }

    public int getBodyID1(int idx) {
        return this.intArray[idx * 5 + 2];
    }

    public void setBodyID1(int id) {
        this.intArray[this.index * 5 + 2] = id;
    }

    public void setBodyID1(int id, int idx) {
        this.intArray[idx * 5 + 2] = id;
    }

    public int getBodyID2() {
        return this.intArray[this.index * 5 + 3];
    }

    public int getBodyID2(int idx) {
        return this.intArray[idx * 5 + 3];
    }

    public void setBodyID2(int id) {
        this.intArray[this.index * 5 + 3] = id;
    }

    public void setBodyID2(int id, int idx) {
        this.intArray[idx * 5 + 3] = id;
    }

    public int getMode() {
        return this.intArray[this.index * 5 + 4];
    }

    public int getMode(int idx) {
        return this.intArray[idx * 5 + 4];
    }

    public void setMode(int mode) {
        this.intArray[this.index * 5 + 4] = mode;
    }

    public void setMode(int mode, int idx) {
        this.intArray[idx * 5 + 4] = mode;
    }

    public void getPosition(Vector3f position) {
        position.x = this.floatArray[this.index * 20 + 0];
        position.y = this.floatArray[this.index * 20 + 0 + 1];
        position.z = this.floatArray[this.index * 20 + 0 + 2];
    }

    public void getPosition(Vector3f position, int idx) {
        position.x = this.floatArray[idx * 20 + 0];
        position.y = this.floatArray[idx * 20 + 0 + 1];
        position.z = this.floatArray[idx * 20 + 0 + 2];
    }

    public void getPosition(float[] position) {
        position[0] = this.floatArray[this.index * 20 + 0];
        position[1] = this.floatArray[this.index * 20 + 0 + 1];
        position[2] = this.floatArray[this.index * 20 + 0 + 2];
    }

    public void getPosition(float[] position, int idx) {
        position[0] = this.floatArray[idx * 20 + 0];
        position[1] = this.floatArray[idx * 20 + 0 + 1];
        position[2] = this.floatArray[idx * 20 + 0 + 2];
    }

    public float[] getPosition() {
        float[] position = new float[]{this.floatArray[this.index * 20 + 0], this.floatArray[this.index * 20 + 0 + 1], this.floatArray[this.index * 20 + 0 + 2]};
        return position;
    }

    public float[] getPosition(int idx) {
        float[] position = new float[]{this.floatArray[idx * 20 + 0], this.floatArray[idx * 20 + 0 + 1], this.floatArray[idx * 20 + 0 + 2]};
        return position;
    }

    public void setPosition(float[] position) {
        this.floatArray[this.index * 20 + 0] = position[0];
        this.floatArray[this.index * 20 + 0 + 1] = position[1];
        this.floatArray[this.index * 20 + 0 + 2] = position[2];
    }

    public void setPosition(float[] position, int idx) {
        this.floatArray[idx * 20 + 0] = position[0];
        this.floatArray[idx * 20 + 0 + 1] = position[1];
        this.floatArray[idx * 20 + 0 + 2] = position[2];
    }

    public void getNormal(Vector3f normal) {
        normal.x = this.floatArray[this.index * 20 + 3];
        normal.y = this.floatArray[this.index * 20 + 3 + 1];
        normal.z = this.floatArray[this.index * 20 + 3 + 2];
    }

    public void getNormal(Vector3f normal, int idx) {
        normal.x = this.floatArray[idx * 20 + 3];
        normal.y = this.floatArray[idx * 20 + 3 + 1];
        normal.z = this.floatArray[idx * 20 + 3 + 2];
    }

    public void getNormal(float[] normal) {
        normal[0] = this.floatArray[this.index * 20 + 3];
        normal[1] = this.floatArray[this.index * 20 + 3 + 1];
        normal[2] = this.floatArray[this.index * 20 + 3 + 2];
    }

    public void getNormal(float[] normal, int idx) {
        normal[0] = this.floatArray[idx * 20 + 3];
        normal[1] = this.floatArray[idx * 20 + 3 + 1];
        normal[2] = this.floatArray[idx * 20 + 3 + 2];
    }

    public float[] getNormal() {
        float[] normal = new float[]{this.floatArray[this.index * 20 + 3], this.floatArray[this.index * 20 + 3 + 1], this.floatArray[this.index * 20 + 3 + 2]};
        return normal;
    }

    public float[] getNormal(int idx) {
        float[] normal = new float[]{this.floatArray[idx * 20 + 3], this.floatArray[idx * 20 + 3 + 1], this.floatArray[idx * 20 + 3 + 2]};
        return normal;
    }

    public void setNormal(float[] normal) {
        this.floatArray[this.index * 20 + 3] = normal[0];
        this.floatArray[this.index * 20 + 3 + 1] = normal[1];
        this.floatArray[this.index * 20 + 3 + 2] = normal[2];
    }

    public void setNormal(float[] normal, int idx) {
        this.floatArray[idx * 20 + 3] = normal[0];
        this.floatArray[idx * 20 + 3 + 1] = normal[1];
        this.floatArray[idx * 20 + 3 + 2] = normal[2];
    }

    public float getDepth() {
        return this.floatArray[this.index * 20 + 6];
    }

    public float getDepth(int idx) {
        return this.floatArray[idx * 20 + 6];
    }

    public void setDepth(float depth) {
        this.floatArray[this.index * 20 + 6] = depth;
    }

    public void setDepth(float depth, int idx) {
        this.floatArray[idx * 20 + 6] = depth;
    }

    public void getFdir1(float[] fdir1) {
        fdir1[0] = this.floatArray[this.index * 20 + 7];
        fdir1[1] = this.floatArray[this.index * 20 + 7 + 1];
        fdir1[2] = this.floatArray[this.index * 20 + 7 + 2];
    }

    public void getFdir1(float[] fdir1, int idx) {
        fdir1[0] = this.floatArray[idx * 20 + 7];
        fdir1[1] = this.floatArray[idx * 20 + 7 + 1];
        fdir1[2] = this.floatArray[idx * 20 + 7 + 2];
    }

    public void setFdir1(float[] fdir1) {
        this.floatArray[this.index * 20 + 7] = fdir1[0];
        this.floatArray[this.index * 20 + 7 + 1] = fdir1[1];
        this.floatArray[this.index * 20 + 7 + 2] = fdir1[2];
    }

    public void setFdir1(float[] fdir1, int idx) {
        this.floatArray[idx * 20 + 7] = fdir1[0];
        this.floatArray[idx * 20 + 7 + 1] = fdir1[1];
        this.floatArray[idx * 20 + 7 + 2] = fdir1[2];
    }

    public float getMu() {
        return this.floatArray[this.index * 20 + 10];
    }

    public float getMu(int idx) {
        return this.floatArray[idx * 20 + 10];
    }

    public void setMu(float mu) {
        this.floatArray[this.index * 20 + 10] = mu;
    }

    public void setMu(float mu, int idx) {
        this.floatArray[idx * 20 + 10] = mu;
    }

    public float getMu2() {
        return this.floatArray[this.index * 20 + 11];
    }

    public float getMu2(int idx) {
        return this.floatArray[idx * 20 + 11];
    }

    public void setMu2(float mu2) {
        this.floatArray[this.index * 20 + 11] = mu2;
    }

    public void setMu2(float mu2, int idx) {
        this.floatArray[idx * 20 + 11] = mu2;
    }

    public float getBounce() {
        return this.floatArray[this.index * 20 + 12];
    }

    public float getBounce(int idx) {
        return this.floatArray[idx * 20 + 12];
    }

    public void setBounce(float bounce) {
        this.floatArray[this.index * 20 + 12] = bounce;
    }

    public void setBounce(float bounce, int idx) {
        this.floatArray[idx * 20 + 12] = bounce;
    }

    public float getBounceVel() {
        return this.floatArray[this.index * 20 + 13];
    }

    public float getBounceVel(int idx) {
        return this.floatArray[idx * 20 + 13];
    }

    public void setBounceVel(float bounceVel) {
        this.floatArray[this.index * 20 + 13] = bounceVel;
    }

    public void setBounceVel(float bounceVel, int idx) {
        this.floatArray[idx * 20 + 13] = bounceVel;
    }

    public float getSoftErp() {
        return this.floatArray[this.index * 20 + 14];
    }

    public float getSoftErp(int idx) {
        return this.floatArray[idx * 20 + 14];
    }

    public void setSoftErp(float softErp) {
        this.floatArray[this.index * 20 + 14] = softErp;
    }

    public void setSoftErp(float softErp, int idx) {
        this.floatArray[idx * 20 + 14] = softErp;
    }

    public float getSoftCfm() {
        return this.floatArray[this.index * 20 + 15];
    }

    public float getSoftCfm(int idx) {
        return this.floatArray[idx * 20 + 15];
    }

    public void setSoftCfm(float softCfm) {
        this.floatArray[this.index * 20 + 15] = softCfm;
    }

    public void setSoftCfm(float softCfm, int idx) {
        this.floatArray[idx * 20 + 15] = softCfm;
    }

    public float getMotion1() {
        return this.floatArray[this.index * 20 + 16];
    }

    public float getMotion1(int idx) {
        return this.floatArray[idx * 20 + 16];
    }

    public void setMotion1(float motion1) {
        this.floatArray[this.index * 20 + 16] = motion1;
    }

    public void setMotion1(float motion1, int idx) {
        this.floatArray[idx * 20 + 16] = motion1;
    }

    public float getMotion2() {
        return this.floatArray[this.index * 20 + 17];
    }

    public float getMotion2(int idx) {
        return this.floatArray[idx * 20 + 17];
    }

    public void setMotion2(float motion2) {
        this.floatArray[this.index * 20 + 17] = motion2;
    }

    public void setMotion2(float motion2, int idx) {
        this.floatArray[idx * 20 + 17] = motion2;
    }

    public float getSlip1() {
        return this.floatArray[this.index * 20 + 18];
    }

    public float getSlip1(int idx) {
        return this.floatArray[idx * 20 + 18];
    }

    public void setSlip1(float slip1) {
        this.floatArray[this.index * 20 + 18] = slip1;
    }

    public void setSlip1(float slip1, int idx) {
        this.floatArray[idx * 20 + 18] = slip1;
    }

    public float getSlip2() {
        return this.floatArray[this.index * 20 + 19];
    }

    public float getSlip2(int idx) {
        return this.floatArray[idx * 20 + 19];
    }

    public void setSlip2(float slip2) {
        this.floatArray[this.index * 20 + 19] = slip2;
    }

    public void setSlip2(float slip2, int idx) {
        this.floatArray[idx * 20 + 19] = slip2;
    }
}

