/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.Odejava;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dWorldID;
import org.odejava.ode.SWIGTYPE_p_float;

public class World {
    private static final float DEFAULT_STEPSIZE = 0.05f;
    private static final int DEFAULT_ITERATIONS = 10;
    private SWIGTYPE_p_dWorldID worldId = Ode.dWorldCreate();
    private float stepSize = 0.05f;
    private int stepInteractions = 10;
    protected List bodyList = new LinkedList();
    protected Map bodyMap = new HashMap();
    protected boolean deleted = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setGravity(float x, float y, float z) {
        Ode.dWorldSetGravity(this.worldId, x, y, z);
    }

    public Vector3f getGravity() {
        return this.getGravity((Vector3f)null);
    }

    public Vector3f getGravity(Vector3f val) {
        Vector3f ret = val;
        if (ret == null) {
            ret = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dWorldGetGravity(this.worldId, arr);
        ret.x = Ode.floatArray_getitem(arr, 0);
        ret.y = Ode.floatArray_getitem(arr, 1);
        ret.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return ret;
    }

    public void getGravity(float[] val) {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dWorldGetGravity(this.worldId, arr);
        val[0] = Ode.floatArray_getitem(arr, 0);
        val[1] = Ode.floatArray_getitem(arr, 1);
        val[2] = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
    }

    public SWIGTYPE_p_dWorldID getId() {
        return this.worldId;
    }

    public void stepFast() {
        Ode.dWorldStepFast1(this.worldId, this.stepSize, this.stepInteractions);
    }

    public void step() {
        Ode.dWorldStep(this.worldId, this.stepSize);
    }

    public void step(float stepTime) {
        Ode.dWorldStep(this.worldId, stepTime);
    }

    public void quickStep() {
        Ode.dWorldQuickStep(this.worldId, this.stepSize);
    }

    public void quickStep(float stepTime) {
        Ode.dWorldQuickStep(this.worldId, stepTime);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        Ode.dWorldDestroy(this.worldId);
        this.deleted = true;
    }

    public int getStepInteractions() {
        return this.stepInteractions;
    }

    public void setStepInteractions(int stepInteractions) {
        this.stepInteractions = stepInteractions;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    protected void addBody(Body body) {
        if (!$assertionsDisabled && this.bodyList.contains(body)) {
            throw new AssertionError((Object)"Body already exists in this world");
        }
        this.bodyList.add(body);
        if (body.getName() != null) {
            if (this.bodyMap.containsKey(body.getName())) {
                Odejava.log.warn("Adding a second body with the name " + body.getName() + " to this world.  Calls to getBody may now be ambiguous.");
            }
            this.bodyMap.put(body.getName(), body);
        }
    }

    protected void removeBody(Body body) {
        if (!$assertionsDisabled && !this.bodyList.contains(body)) {
            throw new AssertionError((Object)"Body already removed from in this world");
        }
        this.bodyList.remove(body);
        if (body.getName() != null) {
            this.bodyMap.remove(body.getName());
        }
    }

    public List getBodies() {
        return this.bodyList;
    }

    public Body getBody(String name) {
        return (Body)this.bodyMap.get(name);
    }

    public void deleteBody(Body body) {
        if (!this.bodyList.contains(body)) {
            throw new IllegalArgumentException("Body isn't in this World");
        }
        this.bodyList.remove(body);
        this.bodyMap.remove(body.getName());
        body.delete();
    }

    public Body findGeomBody(Geom geom) {
        Iterator i = this.bodyList.iterator();
        while (i.hasNext()) {
            Body body = (Body)i.next();
            Iterator j = body.getGeoms().iterator();
            while (j.hasNext()) {
                if ((Geom)j.next() != geom) continue;
                return body;
            }
        }
        return null;
    }

    public void setAutoEnableDepthSF1(int autoEnableDepth) {
        Ode.dWorldSetAutoEnableDepthSF1(this.worldId, autoEnableDepth);
    }

    public int getAutoEnableDepthSF1(int autoEnableDepth) {
        return Ode.dWorldGetAutoEnableDepthSF1(this.worldId);
    }

    public void setContactSurfaceThickness(float depth) {
    }

    public float getContactSurfaceThickness() {
        return 0.0f;
    }

    public void setAutoDisableBodies(boolean state) {
    }

    public boolean isAutoDisablingBodies() {
        boolean ret = false;
        return ret;
    }

    public void setLinearVelocityDisableThreshold(float vel) {
    }

    public float getLinearVelocityDisableThreshold() {
        return 0.01f;
    }

    public void setAngularVelocityDisableThreshold(float vel) {
    }

    public float getAngularVelocityDisableThreshold() {
        return 0.01f;
    }

    public void setStepDisableThreshold(int steps) {
    }

    public int getStepDisableThreshold() {
        return 10;
    }

    public void setTimeDisableThreshold(float time) {
    }

    public float getTimeDisableThreshold() {
        return 0.0f;
    }

    public void setConstantForceMix(float force) {
        Ode.dWorldSetCFM(this.worldId, force);
    }

    public float getConstantForceMix() {
        return Ode.dWorldGetCFM(this.worldId);
    }

    public void setErrorReductionParameter(float erp) {
        Ode.dWorldSetERP(this.worldId, erp);
    }

    public float getErrorReductionParameter() {
        return Ode.dWorldGetERP(this.worldId);
    }

    public void setMaxCorrectionVelocity(float vel) {
    }

    public float getMaxCorrectionVelocity() {
        return 0.0f;
    }

    static {
        $assertionsDisabled = !World.class.desiredAssertionStatus();
    }
}

