/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.IllegalOdejavaOperation;
import org.odejava.Odejava;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dSpaceID;

public abstract class Space {
    protected SWIGTYPE_p_dSpaceID spaceId;
    protected SWIGTYPE_p_dSpaceID parentId;
    protected LinkedList geomList;
    protected HashMap geomMap;
    public static final SWIGTYPE_p_dSpaceID SPACEID_ZERO = Ode.getPARENTSPACEID_ZERO();
    protected boolean deleted;

    public Space() {
        this(null);
    }

    public Space(Space parent) {
        this.parentId = parent == null ? Ode.getPARENTSPACEID_ZERO() : parent.spaceId;
        this.geomList = new LinkedList();
        this.geomMap = new HashMap();
        this.deleted = false;
    }

    public void addGeom(Geom geom) {
        if (this.geomList.contains(geom)) {
            throw new IllegalOdejavaOperation("Attempting to add a Geom which already belongs to this Body!");
        }
        geom.addToSpace(this);
        this.geomList.add(geom);
        if (geom.getName() != null) {
            if (this.geomMap.containsKey(geom.getName())) {
                Odejava.log.warn("Adding a second geom with the name " + geom.getName() + " to this Space.  Calls to getGeom may be now be ambiguous.");
            }
            this.geomMap.put(geom.getName(), geom);
        }
    }

    public void add(Geom geom) {
        this.addGeom(geom);
    }

    public void addBodyGeoms(Body body) {
        Iterator i = body.getGeoms().iterator();
        while (i.hasNext()) {
            this.addGeom((Geom)i.next());
        }
    }

    public void remove(Geom geom) {
        if (!this.geomList.contains(geom)) {
            throw new IllegalArgumentException("Geom is not currently in this space");
        }
        geom.removeFromSpace();
        this.geomList.remove(geom);
        this.geomMap.remove(geom.getName());
    }

    public List getGeoms() {
        return new LinkedList(this.geomList);
    }

    public Geom getGeom(String name) {
        return (Geom)this.geomMap.get(name);
    }

    public HashMap getGeomMap() {
        return this.geomMap;
    }

    public void setChildCleanupMode(boolean killKids) {
        Ode.dSpaceSetCleanup(this.spaceId, killKids ? 1 : 0);
    }

    public boolean getChildCleanupMode() {
        return Ode.dSpaceGetCleanup(this.spaceId) == 1;
    }

    public void delete() {
        Iterator i = this.getGeoms().iterator();
        while (i.hasNext()) {
            ((Geom)i.next()).delete();
        }
        Ode.dSpaceDestroy(this.spaceId);
        this.deleted = true;
    }

    public SWIGTYPE_p_dSpaceID getId() {
        return this.spaceId;
    }
}

