/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.IllegalOdejavaOperation;
import org.odejava.Placeable;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_float;

public abstract class PlaceableGeom
extends Geom
implements Placeable {
    private Body body;
    private SWIGTYPE_p_float posArray;
    private SWIGTYPE_p_float rotArray;
    private SWIGTYPE_p_float quatArray = Ode.new_floatArray(4);
    private boolean fixed = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PlaceableGeom() {
    }

    protected PlaceableGeom(String name) {
        super(name);
    }

    public void setPosition(Vector3f position) {
        Ode.dGeomSetPosition(this.geomId, position.x, position.y, position.z);
    }

    public void setQuaternion(Quat4f quaternion) {
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(4);
        Ode.floatArray_setitem(tmpArray, 0, quaternion.w);
        Ode.floatArray_setitem(tmpArray, 1, quaternion.x);
        Ode.floatArray_setitem(tmpArray, 2, quaternion.y);
        Ode.floatArray_setitem(tmpArray, 3, quaternion.z);
        Ode.dGeomSetQuaternion(this.geomId, tmpArray);
        Ode.delete_floatArray(tmpArray);
    }

    public void setRotation(Matrix3f r) {
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(12);
        Ode.floatArray_setitem(tmpArray, 0, r.getElement(0, 0));
        Ode.floatArray_setitem(tmpArray, 1, r.getElement(0, 1));
        Ode.floatArray_setitem(tmpArray, 2, r.getElement(0, 2));
        Ode.floatArray_setitem(tmpArray, 4, r.getElement(1, 0));
        Ode.floatArray_setitem(tmpArray, 5, r.getElement(1, 1));
        Ode.floatArray_setitem(tmpArray, 6, r.getElement(1, 2));
        Ode.floatArray_setitem(tmpArray, 8, r.getElement(2, 0));
        Ode.floatArray_setitem(tmpArray, 9, r.getElement(2, 1));
        Ode.floatArray_setitem(tmpArray, 10, r.getElement(2, 2));
        Ode.dGeomSetRotation(this.geomId, tmpArray);
        Ode.delete_floatArray(tmpArray);
    }

    public void setAxisAndAngle(AxisAngle4f axisAngle) {
        this.setAxisAndAngle(axisAngle.x, axisAngle.y, axisAngle.z, axisAngle.angle);
    }

    public void setAxisAndAngle(float ax, float ay, float az, float angle) {
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(4);
        Ode.dQFromAxisAndAngle(tmpArray, ax, ay, az, angle);
        Ode.dGeomSetQuaternion(this.geomId, tmpArray);
        Ode.delete_floatArray(tmpArray);
    }

    public AxisAngle4f getAxisAngle() {
        return this.getAxisAngle(null);
    }

    public AxisAngle4f getAxisAngle(AxisAngle4f result) {
        if (result == null) {
            result = new AxisAngle4f();
        }
        Quat4f q1 = this.getQuaternion();
        result.set(q1);
        return result;
    }

    public Vector3f getPosition() {
        return this.getPosition((Vector3f)null);
    }

    public Vector3f getPosition(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        this.posArray = Ode.dGeomGetPosition(this.geomId);
        result.x = Ode.floatArray_getitem(this.posArray, 0);
        result.y = Ode.floatArray_getitem(this.posArray, 1);
        result.z = Ode.floatArray_getitem(this.posArray, 2);
        return result;
    }

    public void getPosition(float[] result) {
        this.posArray = Ode.dGeomGetPosition(this.geomId);
        result[0] = Ode.floatArray_getitem(this.posArray, 0);
        result[1] = Ode.floatArray_getitem(this.posArray, 1);
        result[2] = Ode.floatArray_getitem(this.posArray, 2);
    }

    public void setPosition(float x, float y, float z) {
        Ode.dGeomSetPosition(this.geomId, x, y, z);
    }

    public Quat4f getQuaternion() {
        return this.getQuaternion(null);
    }

    public Quat4f getQuaternion(Quat4f result) {
        Ode.dGeomGetQuaternion(this.geomId, this.quatArray);
        if (result == null) {
            result = new Quat4f();
        }
        result.x = Ode.floatArray_getitem(this.quatArray, 1);
        result.y = Ode.floatArray_getitem(this.quatArray, 2);
        result.z = Ode.floatArray_getitem(this.quatArray, 3);
        result.w = Ode.floatArray_getitem(this.quatArray, 0);
        return result;
    }

    public Matrix3f getRotation() {
        this.rotArray = Ode.dGeomGetRotation(this.geomId);
        Matrix3f result = new Matrix3f();
        result.set(new float[]{Ode.floatArray_getitem(this.rotArray, 0), Ode.floatArray_getitem(this.rotArray, 1), Ode.floatArray_getitem(this.rotArray, 2), Ode.floatArray_getitem(this.rotArray, 4), Ode.floatArray_getitem(this.rotArray, 5), Ode.floatArray_getitem(this.rotArray, 6), Ode.floatArray_getitem(this.rotArray, 8), Ode.floatArray_getitem(this.rotArray, 9), Ode.floatArray_getitem(this.rotArray, 10)});
        return result;
    }

    public Body getBody() {
        return this.body;
    }

    protected void setBody(Body body) {
        boolean legalOperation = true;
        if (this.body != null && body != null && this.body != body) {
            legalOperation = false;
        }
        if (!legalOperation) {
            throw new IllegalOdejavaOperation("Attempt to create a second Body parent for this Geom.  As a Geoms can only have one parent, it's current parent must first be removed (by calling its removeGeom method) before a new one can be set.");
        }
        if (this.isEncapsulated) {
            System.out.println("Odejava: Warning - an Encapsulated geom was added to a body.  You probably don't want to use the parent GeomTransform instead.");
        }
        this.body = body;
        if (body != null) {
            if (!$assertionsDisabled && !body.getGeoms().contains(this)) {
                throw new AssertionError((Object)"This method should only be called by Body.addGeom.  The passed Body does not have this Geom listed as one of its Geoms.  If this action were allowed, it would be possible for several Bodies to think they had this Geom as a child, when in actual fact it can only belong to one.");
            }
            Ode.dGeomSetBody(this.getId(), body.getId());
        } else {
            Ode.dGeomSetBody(this.getId(), Ode.getBODYID_ZERO());
        }
        this.fixed = body == null;
    }

    public boolean fixed() {
        return this.fixed;
    }

    public void delete() {
        if (this.body != null) {
            this.body.removeGeom(this);
        }
        super.delete();
    }

    static {
        $assertionsDisabled = !PlaceableGeom.class.desiredAssertionStatus();
    }
}

