/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_float;
import org.odejava.ode.SWIGTYPE_p_int;

public class Odejava {
    private static Odejava singleton;
    public static Logger log;
    public static Logger odeLog;
    private static boolean loadFailed;

    public static native int getNativeAddr(long var0);

    private Odejava() {
    }

    public static boolean init() {
        if (loadFailed) {
            return false;
        }
        Odejava.getInstance();
        return true;
    }

    public static Odejava getInstance() {
        if (singleton == null) {
            singleton = new Odejava();
        }
        return singleton;
    }

    public static String getLibraryVersion() {
        return Ode.ODEJAVA_VERSION;
    }

    public static SWIGTYPE_p_float createSwigArray(float[] javaArray) {
        SWIGTYPE_p_float result = Ode.new_floatArray(javaArray.length);
        for (int i = 0; i < javaArray.length; ++i) {
            Ode.floatArray_setitem(result, i, javaArray[i]);
        }
        return result;
    }

    public static float[] createJavaArray(SWIGTYPE_p_float swigArray, int length) {
        float[] result = new float[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Ode.floatArray_getitem(swigArray, i);
        }
        return result;
    }

    public static void createVector3f(SWIGTYPE_p_float swigArray, Vector3f v) {
        v.x = Ode.floatArray_getitem(swigArray, 0);
        v.y = Ode.floatArray_getitem(swigArray, 1);
        v.z = Ode.floatArray_getitem(swigArray, 2);
    }

    public static SWIGTYPE_p_int createSwigArray(int[] javaArray) {
        SWIGTYPE_p_int result = Ode.new_intArray(javaArray.length);
        for (int i = 0; i < javaArray.length; ++i) {
            Ode.intArray_setitem(result, i, javaArray[i]);
        }
        return result;
    }

    public static int[] createJavaArray(SWIGTYPE_p_int swigArray, int length) {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Ode.intArray_getitem(swigArray, i);
        }
        return result;
    }

    static {
        log = Logger.getLogger("odejava");
        odeLog = Logger.getLogger("odejava.ode.call");
        PropertyConfigurator.configure(Odejava.class.getClassLoader().getResource("odejavalog4j.properties"));
        loadFailed = false;
        try {
            System.loadLibrary("odejava");
            log.info("Odejava version " + Ode.ODEJAVA_VERSION);
        }
        catch (UnsatisfiedLinkError e) {
            log.fatal("Native code library failed to load. " + e);
            loadFailed = true;
        }
    }
}

