/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Vector3f;
import org.odejava.Joint;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.ode.OdeConstants;
import org.odejava.ode.SWIGTYPE_p_float;

public class JointUniversal
extends Joint {
    public JointUniversal(World world) {
        this(null, world, null);
    }

    public JointUniversal(String name, World world) {
        this(name, world, null);
    }

    public JointUniversal(World world, JointGroup jointGroup) {
        this(null, world, jointGroup);
    }

    public JointUniversal(String name, World world, JointGroup jointGroup) {
        super(name, jointGroup);
        this.jointId = Ode.dJointCreateUniversal(world.getId(), this.jointGroupId);
    }

    public void setAnchor(float x, float y, float z) {
        Ode.dJointSetUniversalAnchor(this.jointId, x, y, z);
    }

    public Vector3f getAnchor() {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetUniversalAnchor(this.jointId, arr);
        Vector3f ret = new Vector3f(Ode.floatArray_getitem(arr, 0), Ode.floatArray_getitem(arr, 1), Ode.floatArray_getitem(arr, 2));
        Ode.delete_floatArray(arr);
        return ret;
    }

    public Vector3f getAnchor2() {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetUniversalAnchor2(this.jointId, arr);
        Vector3f ret = new Vector3f(Ode.floatArray_getitem(arr, 0), Ode.floatArray_getitem(arr, 1), Ode.floatArray_getitem(arr, 2));
        Ode.delete_floatArray(arr);
        return ret;
    }

    public void setAxis1(float x, float y, float z) {
        Ode.dJointSetUniversalAxis1(this.jointId, x, y, z);
    }

    public Vector3f getAxis1() {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetUniversalAxis1(this.jointId, arr);
        Vector3f ret = new Vector3f(Ode.floatArray_getitem(arr, 0), Ode.floatArray_getitem(arr, 1), Ode.floatArray_getitem(arr, 2));
        Ode.delete_floatArray(arr);
        return ret;
    }

    public void setAxis2(float x, float y, float z) {
        Ode.dJointSetUniversalAxis2(this.jointId, x, y, z);
    }

    public Vector3f getAxis2() {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetUniversalAxis2(this.jointId, arr);
        Vector3f ret = new Vector3f(Ode.floatArray_getitem(arr, 0), Ode.floatArray_getitem(arr, 1), Ode.floatArray_getitem(arr, 2));
        Ode.delete_floatArray(arr);
        return ret;
    }

    public float getAngle1() {
        return Ode.dJointGetUniversalAngle1(this.jointId);
    }

    public float getAngle1Rate() {
        return Ode.dJointGetUniversalAngle1Rate(this.jointId);
    }

    public float getAngle2() {
        return Ode.dJointGetUniversalAngle2(this.jointId);
    }

    public float getAngle2Rate() {
        return Ode.dJointGetUniversalAngle2Rate(this.jointId);
    }

    public void setStopBounce(float bounce) throws IllegalArgumentException {
        if (bounce < 0.0f || bounce > 1.0f) {
            throw new IllegalArgumentException("The bounce range value must be a non-negative value: " + bounce);
        }
        Ode.dJointSetHingeParam(this.jointId, OdeConstants.dParamBounce, bounce);
    }

    public float getStopBounce() {
        return Ode.dJointGetHingeParam(this.jointId, OdeConstants.dParamBounce);
    }

    public void setStopBounce2(float bounce) throws IllegalArgumentException {
        if (bounce < 0.0f || bounce > 1.0f) {
            throw new IllegalArgumentException("The bounce range value must be a non-negative value: " + bounce);
        }
        Ode.dJointSetHingeParam(this.jointId, OdeConstants.dParamBounce2, bounce);
    }

    public float getStopBounce2() {
        return Ode.dJointGetHingeParam(this.jointId, OdeConstants.dParamBounce2);
    }

    public void setParam(int parameter, float value) {
        Ode.dJointSetUniversalParam(this.jointId, parameter, value);
    }

    public float getParam(int parameter) {
        return Ode.dJointGetUniversalParam(this.jointId, parameter);
    }
}

