/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Vector3f;
import org.odejava.Joint;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.ode.OdeConstants;
import org.odejava.ode.SWIGTYPE_p_float;

public class JointSlider
extends Joint {
    public JointSlider(World world) {
        this(null, world, null);
    }

    public JointSlider(String name, World world) {
        this(name, world, null);
    }

    public JointSlider(World world, JointGroup jointGroup) {
        this(null, world, jointGroup);
    }

    public JointSlider(String name, World world, JointGroup jointGroup) {
        super(name, jointGroup);
        this.jointId = Ode.dJointCreateSlider(world.getId(), this.jointGroupId);
    }

    public void setAxis1(float x, float y, float z) {
        Ode.dJointSetSliderAxis(this.jointId, x, y, z);
    }

    public void setAxis(float x, float y, float z) {
        Ode.dJointSetSliderAxis(this.jointId, x, y, z);
    }

    public Vector3f getAxis() {
        return this.getAxis(null);
    }

    public Vector3f getAxis(Vector3f val) {
        Vector3f ret = val;
        if (ret == null) {
            ret = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetSliderAxis(this.jointId, arr);
        ret.x = Ode.floatArray_getitem(arr, 0);
        ret.y = Ode.floatArray_getitem(arr, 1);
        ret.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return ret;
    }

    public float getPosition() {
        return Ode.dJointGetSliderPosition(this.jointId);
    }

    public float getPositionRate() {
        return Ode.dJointGetSliderPositionRate(this.jointId);
    }

    public void setMaximumPosition(float distance) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamHiStop, distance);
    }

    public float getMaximumPosition() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamHiStop);
    }

    public void setMinimumPosition(float distance) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamLoStop, distance);
    }

    public float getMinimumPosition() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamLoStop);
    }

    public void setConstantForceMix(float force) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamCFM, force);
    }

    public float getConstantForceMix() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamCFM);
    }

    public void setStopBounce(float bounce) throws IllegalArgumentException {
        if (bounce < 0.0f || bounce > 1.0f) {
            throw new IllegalArgumentException("The bounce range value must be a non-negative value: " + bounce);
        }
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamBounce, bounce);
    }

    public float getStopBounce() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamBounce);
    }

    public void setStopERP(float erp) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamStopERP, erp);
    }

    public float getStopERP() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamStopERP);
    }

    public void setStopCFM(float force) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamStopCFM, force);
    }

    public float getStopCFM() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamStopCFM);
    }

    public void setParam(int parameter, float value) {
        Ode.dJointSetSliderParam(this.jointId, parameter, value);
    }

    public float getParam(int parameter) {
        return Ode.dJointGetSliderParam(this.jointId, parameter);
    }
}

