/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Vector3f;
import org.odejava.Joint;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.ode.OdeConstants;
import org.odejava.ode.SWIGTYPE_p_float;

public class JointHinge2
extends Joint {
    private static final String MIN_ANGLE_RANGE_MSG = "The minimum range angle stop must lie between +/- PI radians: ";
    private static final String MAX_ANGLE_RANGE_MSG = "The maximum range angle stop must lie between +/- PI radians: ";
    private static final String NEG_TORQUE_MSG = "The torque value supplied is negative: ";
    private static final float ZERO_EPS = 1.0E-6f;

    public JointHinge2(World world) {
        this(null, world, null);
    }

    public JointHinge2(String name, World world) {
        this(name, world, null);
    }

    public JointHinge2(World world, JointGroup jointGroup) {
        this(null, world, jointGroup);
    }

    public JointHinge2(String name, World world, JointGroup jointGroup) {
        super(name, jointGroup);
        this.jointId = Ode.dJointCreateHinge2(world.getId(), this.jointGroupId);
    }

    public void setAnchor(float x, float y, float z) {
        Ode.dJointSetHinge2Anchor(this.jointId, x, y, z);
    }

    public void setAnchor(Vector3f position) {
        this.setAnchor(position.x, position.y, position.z);
    }

    public Vector3f getAnchor() {
        return this.getAnchor((Vector3f)null);
    }

    public Vector3f getAnchor(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Anchor(this.jointId, arr);
        result.x = Ode.floatArray_getitem(arr, 0);
        result.y = Ode.floatArray_getitem(arr, 1);
        result.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return result;
    }

    public void getAnchor(float[] result) {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Anchor(this.jointId, arr);
        result[0] = Ode.floatArray_getitem(arr, 0);
        result[1] = Ode.floatArray_getitem(arr, 1);
        result[2] = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
    }

    public Vector3f getAnchor2() {
        return this.getAnchor2((Vector3f)null);
    }

    public Vector3f getAnchor2(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Anchor2(this.jointId, arr);
        result.x = Ode.floatArray_getitem(arr, 0);
        result.y = Ode.floatArray_getitem(arr, 1);
        result.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return result;
    }

    public void getAnchor2(float[] result) {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Anchor2(this.jointId, arr);
        result[0] = Ode.floatArray_getitem(arr, 0);
        result[1] = Ode.floatArray_getitem(arr, 1);
        result[2] = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
    }

    public void setAxis1(float x, float y, float z) {
        Ode.dJointSetHinge2Axis1(this.jointId, x, y, z);
    }

    public Vector3f getAxis1() {
        return this.getAxis1((Vector3f)null);
    }

    public Vector3f getAxis1(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Axis1(this.jointId, arr);
        result.x = Ode.floatArray_getitem(arr, 0);
        result.y = Ode.floatArray_getitem(arr, 1);
        result.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return result;
    }

    public void getAxis1(float[] result) {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Axis1(this.jointId, arr);
        result[0] = Ode.floatArray_getitem(arr, 0);
        result[1] = Ode.floatArray_getitem(arr, 1);
        result[2] = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
    }

    public void setAxis2(float x, float y, float z) {
        Ode.dJointSetHinge2Axis2(this.jointId, x, y, z);
    }

    public Vector3f getAxis2() {
        return this.getAxis2((Vector3f)null);
    }

    public Vector3f getAxis2(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Axis2(this.jointId, arr);
        result.x = Ode.floatArray_getitem(arr, 0);
        result.y = Ode.floatArray_getitem(arr, 1);
        result.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return result;
    }

    public void getAxis2(float[] result) {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHinge2Axis2(this.jointId, arr);
        result[0] = Ode.floatArray_getitem(arr, 0);
        result[1] = Ode.floatArray_getitem(arr, 1);
        result[2] = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
    }

    public float getAngle1() {
        return Ode.dJointGetHinge2Angle1(this.jointId);
    }

    public float getAngle1Rate() {
        return Ode.dJointGetHinge2Angle1Rate(this.jointId);
    }

    public float getAngle2Rate() {
        return Ode.dJointGetHinge2Angle2Rate(this.jointId);
    }

    public void setDesiredAngularVelocity1(float speed) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamVel, speed);
    }

    public float getDesiredAngularVelocity1() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamVel);
    }

    public void setDesiredAngularVelocity2(float speed) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamVel2, speed);
    }

    public float getDesiredAngularVelocity2() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamVel2);
    }

    public void setMaxTorque1(float torque) throws IllegalArgumentException {
        if (torque < 0.0f) {
            throw new IllegalArgumentException(NEG_TORQUE_MSG + torque);
        }
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamFMax, torque);
    }

    public float getMaxTorque1() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamFMax);
    }

    public void setMaxTorque2(float torque) throws IllegalArgumentException {
        if (torque < 0.0f) {
            throw new IllegalArgumentException(NEG_TORQUE_MSG + torque);
        }
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamFMax2, torque);
    }

    public float getMaxTorque2() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamFMax2);
    }

    public void setConstantForceMix(float force) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamCFM, force);
    }

    public float getConstantForceMix() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamCFM);
    }

    public void setConstantForceMix2(float force) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamCFM2, force);
    }

    public float getConstantForceMix2() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamCFM2);
    }

    public void setSuspensionERP(float erp) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamSuspensionERP, erp);
    }

    public float getSuspensionERP() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamSuspensionERP);
    }

    public void setSuspensionCFM(float force) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamSuspensionCFM, force);
    }

    public float getSuspensionCFM() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamSuspensionCFM);
    }

    public void setMinAngleStop(float angle) throws IllegalArgumentException {
        if (!Float.isInfinite(angle) && Math.PI - (double)Math.abs(angle) < (double)-1.0E-6f) {
            throw new IllegalArgumentException(MIN_ANGLE_RANGE_MSG + angle);
        }
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamLoStop, angle);
    }

    public float getMinAngleStop() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamLoStop);
    }

    public void setMaxAngleStop(float angle) throws IllegalArgumentException {
        if (!Float.isInfinite(angle) && Math.PI - (double)Math.abs(angle) < (double)-1.0E-6f) {
            throw new IllegalArgumentException(MAX_ANGLE_RANGE_MSG + angle);
        }
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamHiStop, angle);
    }

    public float getMaxAngleStop() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamHiStop);
    }

    public void setStopBounce(float bounce) throws IllegalArgumentException {
        if (bounce < 0.0f || bounce > 1.0f) {
            throw new IllegalArgumentException("The bounce range value must be a non-negative value: " + bounce);
        }
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamBounce, bounce);
    }

    public float getStopBounce() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamBounce);
    }

    public void setStopERP(float erp) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamStopERP, erp);
    }

    public float getStopERP() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamStopERP);
    }

    public void setStopCFM(float force) {
        Ode.dJointSetHinge2Param(this.jointId, OdeConstants.dParamStopCFM, force);
    }

    public float getStopCFM() {
        return Ode.dJointGetHinge2Param(this.jointId, OdeConstants.dParamStopCFM);
    }

    public void setParam(int parameter, float value) {
        Ode.dJointSetHinge2Param(this.jointId, parameter, value);
    }

    public float getParam(int parameter) {
        return Ode.dJointGetHinge2Param(this.jointId, parameter);
    }
}

