/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Vector3f;
import org.odejava.Joint;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.ode.OdeConstants;
import org.odejava.ode.SWIGTYPE_p_float;

public class JointHinge
extends Joint {
    private static final String MIN_ANGLE_RANGE_MSG = "The minimum range angle stop must lie between +/- PI radians: ";
    private static final String MAX_ANGLE_RANGE_MSG = "The maximum range angle stop must lie between +/- PI radians: ";
    private static final float ZERO_EPS = 1.0E-6f;

    public JointHinge(World world) {
        this(null, world, null);
    }

    public JointHinge(String name, World world) {
        this(name, world, null);
    }

    public JointHinge(World world, JointGroup jointGroup) {
        this(null, world, jointGroup);
    }

    public JointHinge(String name, World world, JointGroup jointGroup) {
        super(name, jointGroup);
        this.jointId = Ode.dJointCreateHinge(world.getId(), this.jointGroupId);
    }

    public void setAnchor(float x, float y, float z) {
        Ode.dJointSetHingeAnchor(this.jointId, x, y, z);
    }

    public Vector3f getAnchor() {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHingeAnchor(this.jointId, arr);
        Vector3f ret = new Vector3f(Ode.floatArray_getitem(arr, 0), Ode.floatArray_getitem(arr, 1), Ode.floatArray_getitem(arr, 2));
        Ode.delete_floatArray(arr);
        return ret;
    }

    public Vector3f getAnchor2() {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHingeAnchor2(this.jointId, arr);
        Vector3f ret = new Vector3f(Ode.floatArray_getitem(arr, 0), Ode.floatArray_getitem(arr, 1), Ode.floatArray_getitem(arr, 2));
        Ode.delete_floatArray(arr);
        return ret;
    }

    public void setAxis1(float x, float y, float z) {
        Ode.dJointSetHingeAxis(this.jointId, x, y, z);
    }

    public void setAxis(float x, float y, float z) {
        Ode.dJointSetHingeAxis(this.jointId, x, y, z);
    }

    public Vector3f getAxis() {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetHingeAxis(this.jointId, arr);
        Vector3f ret = new Vector3f(Ode.floatArray_getitem(arr, 0), Ode.floatArray_getitem(arr, 1), Ode.floatArray_getitem(arr, 2));
        Ode.delete_floatArray(arr);
        return ret;
    }

    public float getAngle() {
        return Ode.dJointGetHingeAngle(this.jointId);
    }

    public float getAngleRate() {
        return Ode.dJointGetHingeAngleRate(this.jointId);
    }

    public void setConstantForceMix(float force) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamCFM, force);
    }

    public float getConstantForceMix() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamCFM);
    }

    public void setMinAngleStop(float angle) throws IllegalArgumentException {
        if (!Float.isInfinite(angle) && Math.PI - (double)Math.abs(angle) < (double)-1.0E-6f) {
            throw new IllegalArgumentException(MIN_ANGLE_RANGE_MSG + angle);
        }
        Ode.dJointSetHingeParam(this.jointId, OdeConstants.dParamLoStop, angle);
    }

    public float getMinAngleStop() {
        return Ode.dJointGetHingeParam(this.jointId, OdeConstants.dParamLoStop);
    }

    public void setMaxAngleStop(float angle) throws IllegalArgumentException {
        if (!Float.isInfinite(angle) && Math.PI - (double)Math.abs(angle) < (double)-1.0E-6f) {
            throw new IllegalArgumentException(MAX_ANGLE_RANGE_MSG + angle);
        }
        Ode.dJointSetHingeParam(this.jointId, OdeConstants.dParamHiStop, angle);
    }

    public float getMaxAngleStop() {
        return Ode.dJointGetHingeParam(this.jointId, OdeConstants.dParamHiStop);
    }

    public void setStopBounce(float bounce) throws IllegalArgumentException {
        if (bounce < 0.0f || bounce > 1.0f) {
            throw new IllegalArgumentException("The bounce range value must be a non-negative value: " + bounce);
        }
        Ode.dJointSetHingeParam(this.jointId, OdeConstants.dParamBounce, bounce);
    }

    public float getStopBounce() {
        return Ode.dJointGetHingeParam(this.jointId, OdeConstants.dParamBounce);
    }

    public void setStopERP(float erp) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamStopERP, erp);
    }

    public float getStopERP() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamStopERP);
    }

    public void setStopCFM(float force) {
        Ode.dJointSetSliderParam(this.jointId, OdeConstants.dParamStopCFM, force);
    }

    public float getStopCFM() {
        return Ode.dJointGetSliderParam(this.jointId, OdeConstants.dParamStopCFM);
    }

    public void setParam(int parameter, float value) {
        Ode.dJointSetHingeParam(this.jointId, parameter, value);
    }

    public float getParam(int parameter) {
        return Ode.dJointGetHingeParam(this.jointId, parameter);
    }
}

