/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.odejava.Joint;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dJointGroupID;

public class JointGroup {
    private String name;
    private SWIGTYPE_p_dJointGroupID jointGroupId;
    protected LinkedList jointList;
    protected HashMap jointMap;

    public JointGroup(String name, int id) {
        this.name = name;
        this.jointGroupId = Ode.dJointGroupCreate(id);
        this.jointList = new LinkedList();
        this.jointMap = new HashMap();
    }

    public JointGroup(String name) {
        this(name, 0);
    }

    public JointGroup() {
        this(null, 0);
    }

    public void addJoint(Joint joint) {
        this.jointList.add(joint);
        if (joint.getName() != null) {
            this.jointMap.put(joint.getName(), joint);
        }
    }

    public SWIGTYPE_p_dJointGroupID getId() {
        return this.jointGroupId;
    }

    public void empty() {
        Iterator i = this.jointList.iterator();
        while (i.hasNext()) {
            ((Joint)i.next()).delete();
        }
        this.jointList = new LinkedList();
        this.jointMap = new HashMap();
        Ode.dJointGroupEmpty(this.jointGroupId);
    }

    public LinkedList getJointList() {
        return this.jointList;
    }

    public HashMap getJointMap() {
        return this.jointMap;
    }

    public Joint getJoint(String name) {
        return (Joint)this.jointMap.get(name);
    }

    public void delete() {
        this.empty();
        Ode.dJointGroupDestroy(this.jointGroupId);
    }
}

