/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Vector3f;
import org.odejava.Joint;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_float;

public class JointBall
extends Joint {
    public JointBall(World world) {
        this(null, world, null);
    }

    public JointBall(String name, World world) {
        this(name, world, null);
    }

    public JointBall(World world, JointGroup jointGroup) {
        this(null, world, jointGroup);
    }

    public JointBall(String name, World world, JointGroup jointGroup) {
        super(name, jointGroup);
        this.jointId = Ode.dJointCreateBall(world.getId(), this.jointGroupId);
    }

    public void setAnchor(float x, float y, float z) {
        Ode.dJointSetBallAnchor(this.jointId, x, y, z);
    }

    public void setAnchor(Vector3f position) {
        this.setAnchor(position.x, position.y, position.z);
    }

    public Vector3f getAnchor() {
        return this.getAnchor((Vector3f)null);
    }

    public Vector3f getAnchor(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetBallAnchor(this.jointId, arr);
        result.x = Ode.floatArray_getitem(arr, 0);
        result.y = Ode.floatArray_getitem(arr, 1);
        result.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return result;
    }

    public void getAnchor(float[] result) {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetBallAnchor(this.jointId, arr);
        result[0] = Ode.floatArray_getitem(arr, 0);
        result[1] = Ode.floatArray_getitem(arr, 1);
        result[2] = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
    }

    public Vector3f getAnchor2() {
        return this.getAnchor2((Vector3f)null);
    }

    public Vector3f getAnchor2(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetBallAnchor2(this.jointId, arr);
        result.x = Ode.floatArray_getitem(arr, 0);
        result.y = Ode.floatArray_getitem(arr, 1);
        result.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return result;
    }

    public void getAnchor2(float[] result) {
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetBallAnchor2(this.jointId, arr);
        result[0] = Ode.floatArray_getitem(arr, 0);
        result[1] = Ode.floatArray_getitem(arr, 1);
        result[2] = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
    }
}

