/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Vector3f;
import org.odejava.Joint;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_float;

public class JointAMotor
extends Joint {
    public JointAMotor(World world) {
        this(null, world, null);
    }

    public JointAMotor(String name, World world) {
        this(name, world, null);
    }

    public JointAMotor(World world, JointGroup jointGroup) {
        this(null, world, jointGroup);
    }

    public JointAMotor(String name, World world, JointGroup jointGroup) {
        super(name, jointGroup);
        this.jointId = Ode.dJointCreateAMotor(world.getId(), this.jointGroupId);
    }

    public void setMode(int mode) {
        Ode.dJointSetAMotorMode(this.jointId, mode);
    }

    public int getMode() {
        return Ode.dJointGetAMotorMode(this.jointId);
    }

    public void setNumAxes(int num) {
        Ode.dJointSetAMotorNumAxes(this.jointId, num);
    }

    public int getNumAxes() {
        return Ode.dJointGetAMotorNumAxes(this.jointId);
    }

    public void setAxis(int anum, int rel, float x, float y, float z) {
        Ode.dJointSetAMotorAxis(this.jointId, anum, rel, x, y, z);
    }

    public Vector3f getAxis(int anum) {
        return this.getAxis(anum, null);
    }

    public Vector3f getAxis(int anum, Vector3f val) {
        Vector3f ret = val;
        if (ret == null) {
            ret = new Vector3f();
        }
        SWIGTYPE_p_float arr = Ode.new_floatArray(3);
        Ode.dJointGetAMotorAxis(this.jointId, anum, arr);
        ret.x = Ode.floatArray_getitem(arr, 0);
        ret.y = Ode.floatArray_getitem(arr, 1);
        ret.z = Ode.floatArray_getitem(arr, 2);
        Ode.delete_floatArray(arr);
        return ret;
    }

    public int getAxisRel(int anum) {
        return Ode.dJointGetAMotorAxisRel(this.jointId, anum);
    }

    public void setAngle(int anum, float angle) {
        Ode.dJointSetAMotorAngle(this.jointId, anum, angle);
    }

    public float getAngle(int anum) {
        return Ode.dJointGetAMotorAngle(this.jointId, anum);
    }

    public float getAngleRate(int anum) {
        return Ode.dJointGetAMotorAngleRate(this.jointId, anum);
    }

    public void setParam(int parameter, float value) {
        Ode.dJointSetAMotorParam(this.jointId, parameter, value);
    }

    public float getParam(int parameter) {
        return Ode.dJointGetAMotorParam(this.jointId, parameter);
    }
}

