/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import org.odejava.Body;
import org.odejava.JointFeedback;
import org.odejava.JointGroup;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dBodyID;
import org.odejava.ode.SWIGTYPE_p_dJointGroupID;
import org.odejava.ode.SWIGTYPE_p_dJointID;
import org.odejava.ode.dJointFeedback;

public abstract class Joint {
    protected static final String BOUNCE_RANGE_MSG = "The bounce range value must be a non-negative value: ";
    protected SWIGTYPE_p_dJointGroupID jointGroupId;
    protected SWIGTYPE_p_dJointID jointId;
    protected String name;
    protected JointGroup group;
    protected Body body1;
    protected Body body2;
    protected JointFeedback feedback;
    protected boolean deleted;

    public Joint(String name, JointGroup jointGroup) {
        this.name = name;
        this.group = jointGroup;
        if (jointGroup != null) {
            jointGroup.addJoint(this);
            this.jointGroupId = jointGroup.getId();
        } else {
            this.jointGroupId = Ode.getJOINTGROUPID_ZERO();
        }
        this.deleted = false;
    }

    public void attach(Body body1, Body body2) {
        SWIGTYPE_p_dBodyID id1 = body1 == null ? Ode.getBODYID_ZERO() : body1.getId();
        SWIGTYPE_p_dBodyID id2 = body2 == null ? Ode.getBODYID_ZERO() : body2.getId();
        Ode.dJointAttach(this.jointId, id1, id2);
        this.body1 = body1;
        this.body2 = body2;
    }

    public void delete() {
        Ode.dJointDestroy(this.jointId);
        this.deleted = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void enableFeedbackTracking() {
        this.enableFeedbackTracking(true);
    }

    public void enableFeedbackTracking(boolean state) {
        if (state) {
            if (this.feedback == null) {
                this.feedback = new JointFeedback(new dJointFeedback());
                Ode.dJointSetFeedback(this.jointId, this.feedback.getFeedback());
            }
        } else {
            this.feedback = null;
            Ode.dJointSetFeedback(this.jointId, null);
        }
    }

    public boolean isFeedbackTrackingEnabled() {
        return this.feedback != null;
    }

    public JointFeedback getFeedback() {
        return this.feedback;
    }

    public JointGroup getGroup() {
        return this.group;
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    public void setParam(int parameter, float value) {
    }

    public float getParam(int parameter) {
        return 0.0f;
    }

    public void setAxis1(float x, float y, float z) {
    }

    public void setAxis2(float x, float y, float z) {
    }
}

