/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import org.odejava.Odejava;
import org.odejava.PlaceableGeom;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dxTriMeshData;
import org.odejava.ode.SWIGTYPE_p_float;
import org.odejava.ode.SWIGTYPE_p_int;

public class GeomTriMesh
extends PlaceableGeom {
    private float[] vertices;
    private float[] normals;
    private int[] indices;

    public GeomTriMesh(float[] vertices, int numVertices) {
        super(null);
        int[] indices = new int[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            indices[i] = i;
        }
        this.vertices = vertices;
        this.indices = indices;
        this.init(vertices, null, indices, numVertices);
    }

    public GeomTriMesh(float[] vertices, float[] normals, int numVertices) {
        super(null);
        int[] indices = new int[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            indices[i] = i;
        }
        this.vertices = vertices;
        this.indices = indices;
        this.normals = normals;
        this.init(vertices, normals, indices, numVertices);
    }

    public GeomTriMesh(float[] vertices, int[] indices) {
        super(null);
        this.vertices = vertices;
        this.indices = indices;
        this.init(vertices, null, indices, indices.length);
    }

    public GeomTriMesh(float[] vertices, float[] normals, int[] indices) {
        super(null);
        this.vertices = vertices;
        this.indices = indices;
        this.normals = normals;
        this.init(vertices, normals, indices, indices.length);
    }

    public GeomTriMesh(String name, float[] vertices, int[] indices) {
        super(name);
        this.vertices = vertices;
        this.indices = indices;
        this.init(vertices, null, indices, indices.length);
    }

    public GeomTriMesh(String name, float[] vertices, float[] normals, int[] indices) {
        super(name);
        this.vertices = vertices;
        this.indices = indices;
        this.normals = normals;
        this.init(vertices, normals, indices, indices.length);
    }

    public int[] getIndices() {
        return this.indices;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public float[] getNormals() {
        return this.normals;
    }

    private void init(float[] vertices, float[] normals, int[] indices, int numIndices) {
        SWIGTYPE_p_float tmpVertices = Ode.new_floatArray(vertices.length);
        for (int i = 0; i < vertices.length; ++i) {
            Ode.floatArray_setitem(tmpVertices, i, vertices[i]);
        }
        SWIGTYPE_p_int tmpIndices = Odejava.createSwigArray(indices);
        SWIGTYPE_p_dxTriMeshData data = Ode.dGeomTriMeshDataCreate();
        if (normals != null) {
            SWIGTYPE_p_float tmpNormals = Odejava.createSwigArray(normals);
            Ode.dGeomTriMeshDataBuildSingle1(data, tmpVertices, 3, vertices.length, tmpIndices, numIndices, 3, tmpNormals);
        } else {
            Ode.dGeomTriMeshDataBuildSingle(data, tmpVertices, 3, vertices.length, tmpIndices, indices.length, 3);
        }
        this.spaceId = Ode.getPARENTSPACEID_ZERO();
        this.geomId = Ode.dCreateTriMesh(this.spaceId, data, null, null, null);
        this.updateNativeAddr();
    }
}

