/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.IllegalOdejavaOperation;
import org.odejava.PlaceableGeom;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dGeomID;

public class GeomTransform
extends PlaceableGeom {
    private PlaceableGeom encapsulatedGeom;
    private Matrix4f cachedBodyTransform = new Matrix4f();
    private Matrix4f cachedTmpTransform = new Matrix4f();

    public GeomTransform() {
        this("");
    }

    public GeomTransform(String name) {
        super(name);
        this.spaceId = Ode.getPARENTSPACEID_ZERO();
        this.geomId = Ode.dCreateGeomTransform(this.spaceId);
        this.updateNativeAddr();
    }

    public void setEncapsulatedGeom(PlaceableGeom obj) {
        if (this.encapsulatedGeom != null) {
            throw new IllegalOdejavaOperation("Attempt to assign a second Encapsulated geom.  GeomTransform can only have one encapsualted Geom.");
        }
        this.encapsulatedGeom = obj;
        Ode.dGeomTransformSetGeom(this.geomId, obj.getId());
        this.encapsulatedGeom.isEncapsulated = true;
    }

    public void removeEncapsulatedGeom() {
        Ode.dGeomTransformSetGeom(this.geomId, new SWIGTYPE_p_dGeomID(0L, false));
        this.encapsulatedGeom.isEncapsulated = false;
        this.encapsulatedGeom = null;
    }

    public PlaceableGeom getEncapsulatedGeom() {
        return this.encapsulatedGeom;
    }

    public Vector3f getPosition() {
        return this.getPosition(new Vector3f());
    }

    public Vector3f getPosition(Vector3f result) {
        this.updateCachedTransform();
        this.cachedBodyTransform.get(result);
        return result;
    }

    public Quat4f getQuaternion() {
        return this.getQuaternion(new Quat4f());
    }

    public Quat4f getQuaternion(Quat4f result) {
        this.updateCachedTransform();
        this.cachedBodyTransform.get(result);
        return result;
    }

    public Matrix3f getRotation() {
        return this.getRotation(new Matrix3f());
    }

    public Matrix3f getRotation(Matrix3f result) {
        this.updateCachedTransform();
        this.cachedBodyTransform.get(result);
        return result;
    }

    protected void updateCachedTransform() {
        if (this.getBody() == null) {
            throw new IllegalOdejavaOperation("This GeomTransform must be added to a body before its transform getters can be called.");
        }
        if (this.encapsulatedGeom == null) {
            throw new IllegalOdejavaOperation("This GeomTransform must encapsulate a Geom before its transform getters can be called.");
        }
        this.cachedBodyTransform.setIdentity();
        this.cachedTmpTransform.setIdentity();
        this.cachedBodyTransform.set(this.getBody().getQuaternion());
        this.cachedBodyTransform.setTranslation(this.getBody().getPosition());
        this.cachedTmpTransform.set(this.encapsulatedGeom.getQuaternion());
        this.cachedTmpTransform.setTranslation(this.encapsulatedGeom.getPosition());
        this.cachedBodyTransform.mul(this.cachedTmpTransform);
    }

    public Matrix4f getTransform() {
        return this.getTransform(new Matrix4f());
    }

    public Matrix4f getTransform(Matrix4f result) {
        this.updateCachedTransform();
        result.set(this.cachedBodyTransform);
        return result;
    }
}

