/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import javax.vecmath.Point3f;
import org.odejava.Geom;

public class GeomTerrain
extends Geom {
    private float[] pHeights;
    private float vLength;
    private int numNodesPerSide;

    public GeomTerrain(String name, float[] pHeights, float vLength, int numNodesPerSide) {
        super(name);
        this.pHeights = pHeights;
        this.vLength = vLength;
        this.numNodesPerSide = numNodesPerSide;
    }

    public GeomTerrain(float[] pHeights, float vLength, int numNodesPerSide) {
        this(null, pHeights, vLength, numNodesPerSide);
    }

    public int getNumNodesPerSide() {
        return this.numNodesPerSide;
    }

    public float[] getPHeights() {
        return this.pHeights;
    }

    public float getVLength() {
        return this.vLength;
    }

    public Point3f[] getGeometry() {
        return this.getGeometry(0.0f, 0.0f, 1.0f);
    }

    public Point3f[] getGeometry(float x, float y, float vLength) {
        return GeomTerrain.dsDrawTerrain(x, y, vLength, this.getVLength(), this.getNumNodesPerSide(), this.getPHeights());
    }

    public static Point3f[] dsDrawTerrain(float x, float y, float vLength, float vNodeLength, int nNumNodesPerSide, float[] pHeights) {
        if (pHeights.length != nNumNodesPerSide * nNumNodesPerSide) {
            throw new IllegalArgumentException("Length of the heightmap array must be the square of the number of nodes per side!");
        }
        Point3f A = null;
        Point3f B = null;
        Point3f C = null;
        Point3f D = null;
        float vx = vLength * x;
        float vy = vLength * y;
        Point3f[] coords = new Point3f[nNumNodesPerSide * nNumNodesPerSide * 6];
        int count = 0;
        for (int i = 0; i < nNumNodesPerSide; ++i) {
            for (int j = 0; j < nNumNodesPerSide; ++j) {
                A = new Point3f((float)i * vNodeLength + vx, (float)j * vNodeLength + vy, GeomTerrain.GetHeight(i, j, nNumNodesPerSide, pHeights));
                B = new Point3f((float)(i + 1) * vNodeLength + vx, (float)j * vNodeLength + vy, GeomTerrain.GetHeight(i + 1, j, nNumNodesPerSide, pHeights));
                C = new Point3f((float)i * vNodeLength + vx, (float)(j + 1) * vNodeLength + vy, GeomTerrain.GetHeight(i, j + 1, nNumNodesPerSide, pHeights));
                D = new Point3f((float)(i + 1) * vNodeLength + vx, (float)(j + 1) * vNodeLength + vy, GeomTerrain.GetHeight(i + 1, j + 1, nNumNodesPerSide, pHeights));
                coords[count++] = C;
                coords[count++] = A;
                coords[count++] = B;
                coords[count++] = D;
                coords[count++] = C;
                coords[count++] = B;
            }
        }
        return coords;
    }

    private static float GetHeight(int x, int y, int nNumNodesPerSide, float[] pHeights) {
        int nNumNodesPerSideMask = nNumNodesPerSide - 1;
        return pHeights[(y & nNumNodesPerSideMask) * nNumNodesPerSide + (x & nNumNodesPerSideMask)];
    }
}

