/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import java.util.HashMap;
import org.odejava.Odejava;
import org.odejava.Space;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dGeomID;
import org.odejava.ode.SWIGTYPE_p_dSpaceID;

public abstract class Geom {
    private String name;
    protected SWIGTYPE_p_dSpaceID spaceId;
    protected SWIGTYPE_p_dGeomID geomId;
    private Space space = null;
    private int nativeAddr = 0;
    private Object userData;
    private boolean deleted;
    protected boolean isEncapsulated = false;
    private static HashMap geomNativeAddr;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Geom() {
        this(null);
    }

    protected Geom(String name) {
        this.name = name;
        this.deleted = false;
    }

    public SWIGTYPE_p_dGeomID getId() {
        return this.geomId;
    }

    public void setCategoryBits(long bits) {
        Ode.dGeomSetCategoryBits(this.geomId, bits);
    }

    public void setCollideBits(long bits) {
        Ode.dGeomSetCollideBits(this.geomId, bits);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void delete() {
        if (this.deleted) {
            Odejava.log.warn("Geom " + this.name + " already deleted.");
            return;
        }
        if (this.space != null) {
            this.space.remove(this);
        }
        geomNativeAddr.remove(new Integer(this.nativeAddr));
        Ode.dGeomDestroy(this.geomId);
        this.userData = null;
        this.space = null;
        this.deleted = true;
    }

    protected void finalize() {
        if (!this.deleted) {
            this.delete();
            Odejava.log.warn("Geom " + this.name + " deleted on finalization.");
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            Ode.dGeomEnable(this.geomId);
        } else {
            Ode.dGeomDisable(this.geomId);
        }
    }

    protected void updateNativeAddr() {
        geomNativeAddr.remove(new Integer(this.nativeAddr));
        this.nativeAddr = Odejava.getNativeAddr(this.geomId.getSwigCPtr());
        geomNativeAddr.put(new Integer(this.nativeAddr), this);
    }

    public static Geom getGeomFromNativeAddr(int nativeAddress) {
        return (Geom)geomNativeAddr.get(new Integer(nativeAddress));
    }

    public int getNativeAddr() {
        return this.nativeAddr;
    }

    protected void removeFromSpace() {
        if (!$assertionsDisabled && this.spaceId != null) {
            throw new AssertionError((Object)"This geom is already not in any Space");
        }
        Ode.dSpaceRemove(this.spaceId, this.geomId);
        this.spaceId = Ode.getPARENTSPACEID_ZERO();
        this.space = null;
    }

    protected void addToSpace(Space space) {
        if (!$assertionsDisabled && this.spaceId == null) {
            throw new AssertionError((Object)"Can't add a Geom to a space if it already belongs to one");
        }
        if (this.isEncapsulated) {
            System.out.println("Odejava: Warning - an Encapsulated geom was added to a space.  You probably don't want to use the parent GeomTransform instead.");
        }
        this.spaceId = space.getId();
        this.space = space;
        Ode.dSpaceAdd(this.spaceId, this.geomId);
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    static {
        $assertionsDisabled = !Geom.class.desiredAssertionStatus();
        geomNativeAddr = new HashMap();
    }
}

