/*
 * Decompiled with CFR 0.152.
 */
package org.odejava;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.Geom;
import org.odejava.GeomBox;
import org.odejava.GeomSphere;
import org.odejava.Odejava;
import org.odejava.Placeable;
import org.odejava.PlaceableGeom;
import org.odejava.World;
import org.odejava.ode.Ode;
import org.odejava.ode.SWIGTYPE_p_dBodyID;
import org.odejava.ode.SWIGTYPE_p_dJointID;
import org.odejava.ode.SWIGTYPE_p_dMass;
import org.odejava.ode.SWIGTYPE_p_dWorldID;
import org.odejava.ode.SWIGTYPE_p_float;
import org.odejava.ode.dMass;

public class Body
implements Placeable {
    private String name;
    private SWIGTYPE_p_dBodyID bodyId;
    private int nativeAdr = 0;
    private SWIGTYPE_p_dWorldID worldId;
    private SWIGTYPE_p_dMass massId;
    private boolean deleted;
    private Object userData;
    private World world;
    public static final Body BODYID_ZERO;
    LinkedList geoms = new LinkedList();
    SWIGTYPE_p_float posArray;
    SWIGTYPE_p_float quatArray;
    SWIGTYPE_p_float rotArray;
    SWIGTYPE_p_float angularVelArray;
    SWIGTYPE_p_float forceArray;
    SWIGTYPE_p_float linearVelArray;
    SWIGTYPE_p_float torqueArray;
    static final float DEFAULT_MASS_DENSITY = 1.0f;
    private Quat4f tmpQuat;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Body(World world) {
        this(null, world, null);
    }

    public Body(String name, World world) {
        this(name, world, null);
    }

    public Body(String name, World world, PlaceableGeom geom) {
        this.worldId = world.getId();
        this.name = name;
        this.world = world;
        this.deleted = false;
        this.bodyId = Ode.dBodyCreate(this.worldId);
        dMass mass = new dMass();
        this.massId = mass.getCPtr();
        if (geom != null) {
            this.setGeom(geom);
        }
        Ode.dBodySetMass(this.bodyId, this.massId);
        world.addBody(this);
        this.posArray = Ode.dBodyGetPosition(this.bodyId);
        this.quatArray = Ode.dBodyGetQuaternion(this.bodyId);
        this.rotArray = Ode.dBodyGetRotation(this.bodyId);
        this.angularVelArray = Ode.dBodyGetAngularVel(this.bodyId);
        this.forceArray = Ode.dBodyGetForce(this.bodyId);
        this.linearVelArray = Ode.dBodyGetLinearVel(this.bodyId);
        this.torqueArray = Ode.dBodyGetTorque(this.bodyId);
        this.updateNativeAddr();
    }

    public void setGeom(PlaceableGeom geom) {
        this.addGeom(geom);
    }

    public void addGeom(PlaceableGeom geom) {
        if (!$assertionsDisabled && this.geoms.contains(geom)) {
            throw new AssertionError((Object)"Geom already exists in the Body!");
        }
        this.geoms.add(geom);
        geom.setBody(this);
        if (this.name != null && geom.getName() == null) {
            geom.setName(this.name);
        }
        if (this.massId != null) {
            this.setDefaultMass(geom);
        }
    }

    public void removeGeom(PlaceableGeom geom) {
        if (!$assertionsDisabled && !this.geoms.contains(geom)) {
            throw new AssertionError((Object)"Geom doesn't exist in the Body!");
        }
        this.geoms.remove(geom);
        geom.setBody(null);
    }

    public Geom getGeom() {
        return (Geom)this.geoms.getLast();
    }

    public List getGeoms() {
        return this.geoms;
    }

    public void setDefaultMass(Geom geom) {
        if (geom instanceof GeomBox) {
            float[] size = ((GeomBox)geom).getLengths();
            Ode.dMassSetBox(this.massId, 1.0f, size[0], size[1], size[2]);
        } else if (geom instanceof GeomSphere) {
            float radius = ((GeomSphere)geom).getRadius();
            Ode.dMassSetSphere(this.massId, 1.0f, radius);
        }
    }

    public void setBoxMass(float density, float lx, float ly, float lz) {
        Ode.dMassSetBox(this.massId, density, lx, ly, lz);
    }

    public void setSphereMass(float density, float radius) {
        Ode.dMassSetSphere(this.massId, density, radius);
    }

    public void adjustMass(float mass) {
        if (this.geoms.size() == 0) {
            Odejava.log.warn("Odejava - warn: geoms should be added before the mass is adjusted");
        }
        Ode.dMassAdjust(this.massId, mass);
        Ode.dBodySetMass(this.bodyId, this.massId);
    }

    public void resetRotationAndForces() {
        this.setQuaternion(new Quat4f());
        this.setAngularVel(0.0f, 0.0f, 0.0f);
        this.setLinearVel(0.0f, 0.0f, 0.0f);
        this.setForce(0.0f, 0.0f, 0.0f);
        this.setTorque(0.0f, 0.0f, 0.0f);
    }

    public Vector3f getPosition() {
        return this.getPosition((Vector3f)null);
    }

    public Vector3f getPosition(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        result.x = Ode.floatArray_getitem(this.posArray, 0);
        result.y = Ode.floatArray_getitem(this.posArray, 1);
        result.z = Ode.floatArray_getitem(this.posArray, 2);
        return result;
    }

    public void getPosition(float[] result) {
        result[0] = Ode.floatArray_getitem(this.posArray, 0);
        result[1] = Ode.floatArray_getitem(this.posArray, 1);
        result[2] = Ode.floatArray_getitem(this.posArray, 2);
    }

    public void setPosition(Vector3f position) {
        Ode.dBodySetPosition(this.bodyId, position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        Ode.dBodySetPosition(this.bodyId, x, y, z);
    }

    public AxisAngle4f getAxisAngle() {
        return this.getAxisAngle(null);
    }

    public AxisAngle4f getAxisAngle(AxisAngle4f result) {
        if (result == null) {
            result = new AxisAngle4f();
        }
        if (this.tmpQuat == null) {
            this.tmpQuat = new Quat4f();
        }
        this.tmpQuat.x = Ode.floatArray_getitem(this.quatArray, 1);
        this.tmpQuat.y = Ode.floatArray_getitem(this.quatArray, 2);
        this.tmpQuat.z = Ode.floatArray_getitem(this.quatArray, 3);
        this.tmpQuat.w = Ode.floatArray_getitem(this.quatArray, 0);
        result.set(this.tmpQuat);
        return result;
    }

    public void setAxisAndAngle(AxisAngle4f axisAngle) {
        this.setAxisAndAngle(axisAngle.x, axisAngle.y, axisAngle.z, axisAngle.angle);
    }

    public void setAxisAndAngle(float ax, float ay, float az, float angle) {
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(4);
        Ode.dQFromAxisAndAngle(tmpArray, ax, ay, az, angle);
        Ode.dBodySetQuaternion(this.bodyId, tmpArray);
        Ode.delete_floatArray(tmpArray);
    }

    public Quat4f getQuaternion() {
        return this.getQuaternion((Quat4f)null);
    }

    public Quat4f getQuaternion(Quat4f result) {
        if (result == null) {
            result = new Quat4f();
        }
        result.x = Ode.floatArray_getitem(this.quatArray, 1);
        result.y = Ode.floatArray_getitem(this.quatArray, 2);
        result.z = Ode.floatArray_getitem(this.quatArray, 3);
        result.w = Ode.floatArray_getitem(this.quatArray, 0);
        return result;
    }

    public void setQuaternion(Quat4f quaternion) {
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(4);
        Ode.floatArray_setitem(tmpArray, 0, quaternion.w);
        Ode.floatArray_setitem(tmpArray, 1, quaternion.x);
        Ode.floatArray_setitem(tmpArray, 2, quaternion.y);
        Ode.floatArray_setitem(tmpArray, 3, quaternion.z);
        Ode.dBodySetQuaternion(this.bodyId, tmpArray);
        Ode.delete_floatArray(tmpArray);
    }

    public void getQuaternion(float[] result) {
        result[0] = Ode.floatArray_getitem(this.quatArray, 1);
        result[1] = Ode.floatArray_getitem(this.quatArray, 2);
        result[2] = Ode.floatArray_getitem(this.quatArray, 3);
        result[3] = Ode.floatArray_getitem(this.quatArray, 0);
    }

    public Matrix3f getRotation() {
        return this.getRotation((Matrix3f)null);
    }

    public Matrix3f getRotation(Matrix3f result) {
        if (result == null) {
            result = new Matrix3f();
        }
        result.m00 = Ode.floatArray_getitem(this.rotArray, 0);
        result.m01 = Ode.floatArray_getitem(this.rotArray, 1);
        result.m02 = Ode.floatArray_getitem(this.rotArray, 2);
        result.m10 = Ode.floatArray_getitem(this.rotArray, 4);
        result.m11 = Ode.floatArray_getitem(this.rotArray, 5);
        result.m12 = Ode.floatArray_getitem(this.rotArray, 6);
        result.m20 = Ode.floatArray_getitem(this.rotArray, 8);
        result.m21 = Ode.floatArray_getitem(this.rotArray, 9);
        result.m22 = Ode.floatArray_getitem(this.rotArray, 10);
        return result;
    }

    public void getRotation(float[] result) {
        result[0] = Ode.floatArray_getitem(this.rotArray, 0);
        result[1] = Ode.floatArray_getitem(this.rotArray, 1);
        result[2] = Ode.floatArray_getitem(this.rotArray, 2);
        result[3] = Ode.floatArray_getitem(this.rotArray, 4);
        result[4] = Ode.floatArray_getitem(this.rotArray, 5);
        result[5] = Ode.floatArray_getitem(this.rotArray, 6);
        result[6] = Ode.floatArray_getitem(this.rotArray, 8);
        result[7] = Ode.floatArray_getitem(this.rotArray, 9);
        result[8] = Ode.floatArray_getitem(this.rotArray, 10);
    }

    public void setRotation(Matrix3f r) {
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(12);
        Ode.floatArray_setitem(tmpArray, 0, r.getElement(0, 0));
        Ode.floatArray_setitem(tmpArray, 1, r.getElement(0, 1));
        Ode.floatArray_setitem(tmpArray, 2, r.getElement(0, 2));
        Ode.floatArray_setitem(tmpArray, 4, r.getElement(1, 0));
        Ode.floatArray_setitem(tmpArray, 5, r.getElement(1, 1));
        Ode.floatArray_setitem(tmpArray, 6, r.getElement(1, 2));
        Ode.floatArray_setitem(tmpArray, 8, r.getElement(2, 0));
        Ode.floatArray_setitem(tmpArray, 9, r.getElement(2, 1));
        Ode.floatArray_setitem(tmpArray, 10, r.getElement(2, 2));
        Ode.dBodySetRotation(this.bodyId, tmpArray);
        Ode.delete_floatArray(tmpArray);
    }

    public int getGravityMode() {
        return Ode.dBodyGetGravityMode(this.bodyId);
    }

    public void setGravityMode(int mode) {
        Ode.dBodySetGravityMode(this.bodyId, mode);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            Ode.dBodyEnable(this.bodyId);
        } else {
            Ode.dBodyDisable(this.bodyId);
        }
    }

    public boolean isEnabled() {
        return Ode.dBodyIsEnabled(this.bodyId) != 0;
    }

    public void addForce(float x, float y, float z) {
        Ode.dBodyAddForce(this.bodyId, x, y, z);
    }

    public void addForce(Vector3f force) {
        this.addForce(force.x, force.y, force.z);
    }

    public void addForceAtPos(float fx, float fy, float fz, float px, float py, float pz) {
        Ode.dBodyAddForceAtPos(this.bodyId, fx, fy, fz, px, py, pz);
    }

    public void addForceAtRelPos(float fx, float fy, float fz, float px, float py, float pz) {
        Ode.dBodyAddForceAtRelPos(this.bodyId, fx, fy, fz, px, py, pz);
    }

    public void addRelForce(float fx, float fy, float fz) {
        Ode.dBodyAddRelForce(this.bodyId, fx, fy, fz);
    }

    public void addRelForceAtPos(float fx, float fy, float fz, float px, float py, float pz) {
        Ode.dBodyAddRelForceAtPos(this.bodyId, fx, fy, fz, px, py, pz);
    }

    public void addRelForceAtRelPos(float fx, float fy, float fz, float px, float py, float pz) {
        Ode.dBodyAddRelForceAtRelPos(this.bodyId, fx, fy, fz, px, py, pz);
    }

    public void addTorque(float x, float y, float z) {
        Ode.dBodyAddTorque(this.bodyId, x, y, z);
    }

    public void addTorque(Vector3f torque) {
        this.addTorque(torque.x, torque.y, torque.z);
    }

    public void addRelTorque(float x, float y, float z) {
        Ode.dBodyAddRelTorque(this.bodyId, x, y, z);
    }

    public void addRelTorque(Vector3f torque) {
        this.addRelTorque(torque.x, torque.y, torque.z);
    }

    public int getNumOfJoints() {
        return Ode.dBodyGetNumJoints(this.bodyId);
    }

    public List getJoints() {
        return this.getJoints(null);
    }

    public List getJoints(List result) {
        if (this.getNumOfJoints() == 0) {
            return null;
        }
        if (result == null) {
            result = new ArrayList<SWIGTYPE_p_dJointID>();
        } else {
            result.clear();
        }
        if (this.getNumOfJoints() > 0) {
            for (int i = 0; i < this.getNumOfJoints(); ++i) {
                result.add(Ode.dBodyGetJoint(this.bodyId, i));
            }
        }
        return result;
    }

    public SWIGTYPE_p_dBodyID getId() {
        return this.bodyId;
    }

    public void setId(SWIGTYPE_p_dBodyID bodyId) {
        this.bodyId = bodyId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void delete() {
        if (this.deleted) {
            Odejava.log.warn("Body " + this.name + " already deleted.");
            return;
        }
        Iterator i = new LinkedList(this.geoms).iterator();
        while (i.hasNext()) {
            ((Geom)i.next()).delete();
        }
        Ode.dBodyDestroy(this.bodyId);
        this.world.removeBody(this);
        this.deleted = true;
        this.world = null;
        this.geoms = null;
        this.userData = null;
    }

    public void setForce(Vector3f force) {
        this.setForce(force.x, force.y, force.z);
    }

    public void setForce(float x, float y, float z) {
        Ode.dBodySetForce(this.bodyId, x, y, z);
    }

    public Vector3f getForce() {
        return this.getForce((Vector3f)null);
    }

    public Vector3f getForce(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        result.x = Ode.floatArray_getitem(this.forceArray, 0);
        result.y = Ode.floatArray_getitem(this.forceArray, 1);
        result.z = Ode.floatArray_getitem(this.forceArray, 2);
        return result;
    }

    public void getForce(float[] result) {
        result[0] = Ode.floatArray_getitem(this.forceArray, 0);
        result[1] = Ode.floatArray_getitem(this.forceArray, 1);
        result[2] = Ode.floatArray_getitem(this.forceArray, 2);
    }

    public void setAngularVel(Vector3f angularVel) {
        this.setAngularVel(angularVel.x, angularVel.y, angularVel.z);
    }

    public void setAngularVel(float x, float y, float z) {
        Ode.dBodySetAngularVel(this.bodyId, x, y, z);
    }

    public Vector3f getAngularVel() {
        return this.getAngularVel((Vector3f)null);
    }

    public Vector3f getAngularVel(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        result.x = Ode.floatArray_getitem(this.angularVelArray, 0);
        result.y = Ode.floatArray_getitem(this.angularVelArray, 1);
        result.z = Ode.floatArray_getitem(this.angularVelArray, 2);
        return result;
    }

    public void getAngularVel(float[] result) {
        result[0] = Ode.floatArray_getitem(this.angularVelArray, 0);
        result[1] = Ode.floatArray_getitem(this.angularVelArray, 1);
        result[2] = Ode.floatArray_getitem(this.angularVelArray, 2);
    }

    public void setLinearVel(Vector3f linearVel) {
        this.setLinearVel(linearVel.x, linearVel.y, linearVel.z);
    }

    public void setLinearVel(float x, float y, float z) {
        Ode.dBodySetLinearVel(this.bodyId, x, y, z);
    }

    public Vector3f getLinearVel() {
        return this.getLinearVel((Vector3f)null);
    }

    public Vector3f getLinearVel(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        result.x = Ode.floatArray_getitem(this.linearVelArray, 0);
        result.y = Ode.floatArray_getitem(this.linearVelArray, 1);
        result.z = Ode.floatArray_getitem(this.linearVelArray, 2);
        return result;
    }

    public void getLinearVel(float[] result) {
        result[0] = Ode.floatArray_getitem(this.linearVelArray, 0);
        result[1] = Ode.floatArray_getitem(this.linearVelArray, 1);
        result[2] = Ode.floatArray_getitem(this.linearVelArray, 2);
    }

    public void setTorque(Vector3f torque) {
        this.setTorque(torque.x, torque.y, torque.z);
    }

    public void setTorque(float x, float y, float z) {
        Ode.dBodySetTorque(this.bodyId, x, y, z);
    }

    public Vector3f getTorque() {
        return this.getTorque((Vector3f)null);
    }

    public Vector3f getTorque(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        result.x = Ode.floatArray_getitem(this.torqueArray, 0);
        result.y = Ode.floatArray_getitem(this.torqueArray, 1);
        result.z = Ode.floatArray_getitem(this.torqueArray, 2);
        return result;
    }

    public void getTorque(float[] result) {
        result[0] = Ode.floatArray_getitem(this.torqueArray, 0);
        result[1] = Ode.floatArray_getitem(this.torqueArray, 1);
        result[2] = Ode.floatArray_getitem(this.torqueArray, 2);
    }

    public void setFiniteRotationAxis(Vector3f finiteRotationAxis) {
        this.setFiniteRotationAxis(finiteRotationAxis.x, finiteRotationAxis.y, finiteRotationAxis.z);
    }

    public void setFiniteRotationAxis(float x, float y, float z) {
        Ode.dBodySetFiniteRotationAxis(this.bodyId, x, y, z);
    }

    public Vector3f getFiniteRotationAxis() {
        return this.getFiniteRotationAxis((Vector3f)null);
    }

    public Vector3f getFiniteRotationAxis(Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(4);
        Ode.dBodyGetFiniteRotationAxis(this.bodyId, tmpArray);
        result.x = Ode.floatArray_getitem(tmpArray, 0);
        result.y = Ode.floatArray_getitem(tmpArray, 1);
        result.z = Ode.floatArray_getitem(tmpArray, 2);
        Ode.delete_floatArray(tmpArray);
        return result;
    }

    public void getFiniteRotationAxis(float[] result) {
        SWIGTYPE_p_float tmpArray = Ode.new_floatArray(4);
        Ode.dBodyGetFiniteRotationAxis(this.bodyId, tmpArray);
        result[0] = Ode.floatArray_getitem(tmpArray, 0);
        result[1] = Ode.floatArray_getitem(tmpArray, 1);
        result[2] = Ode.floatArray_getitem(tmpArray, 2);
        Ode.delete_floatArray(tmpArray);
    }

    public void setFiniteRotationMode(int mode) {
        Ode.dBodySetFiniteRotationMode(this.bodyId, mode);
    }

    public int getFiniteRotationMode() {
        return Ode.dBodyGetFiniteRotationMode(this.bodyId);
    }

    public SWIGTYPE_p_dBodyID getBodyId() {
        return this.bodyId;
    }

    protected void updateNativeAddr() {
        this.nativeAdr = Odejava.getNativeAddr(this.bodyId.getSwigCPtr());
    }

    public int getNativeAddr() {
        return this.nativeAdr;
    }

    public void setMassParameters(float themass, float cgx, float cgy, float cgz, float I11, float I22, float I33, float I12, float I13, float I23) {
        Ode.dMassSetParameters(this.massId, themass, cgx, cgy, cgz, I11, I22, I33, I12, I13, I23);
        Ode.dBodySetMass(this.bodyId, this.massId);
    }

    public boolean fixed() {
        return false;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public void setAutoDisable(boolean state) {
    }

    public boolean isAutoDisabling() {
        boolean ret = false;
        return ret;
    }

    public void setLinearVelocityDisableThreshold(float vel) {
    }

    public float getLinearVelocityDisableThreshold() {
        return 0.01f;
    }

    public void setAngularVelocityDisableThreshold(float vel) {
    }

    public float getAngularVelocityDisableThreshold() {
        return 0.01f;
    }

    public void setStepDisableThreshold(int steps) {
    }

    public int getStepDisableThreshold() {
        return 10;
    }

    public void setTimeDisableThreshold(float time) {
    }

    public float getTimeDisableThreshold() {
        return 0.0f;
    }

    static {
        $assertionsDisabled = !Body.class.desiredAssertionStatus();
        BODYID_ZERO = null;
    }
}

