/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.MonolineFormatter;

public final class Logging {
    private static final Comparator COMPARATOR;
    private static final Logging[] EMPTY;
    public static final Logging ALL;
    public static final Logging GEOTOOLS;
    final String name;
    private Logging[] children = EMPTY;
    private LoggerFactory factory;
    private static boolean sameLoggerFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Logging() {
        this.name = "";
    }

    private Logging(Logging parent, String name) {
        this.name = name;
        this.factory = parent.factory;
        if (!$assertionsDisabled && !name.startsWith(parent.name)) {
            throw new AssertionError((Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            Logger logger;
            LoggerFactory factory;
            Logging logging;
            Logging logging2 = logging = sameLoggerFactory ? ALL : Logging.getLogging(name, false);
            if (logging != null && (factory = logging.factory) != null && (logger = factory.getLogger(name)) != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return logger;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Logger.getLogger(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logging getLogging(String name) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Logging.getLogging(name, true);
        }
    }

    private static Logging getLogging(String base, boolean create) {
        if (!$assertionsDisabled && !Thread.holdsLock(EMPTY)) {
            throw new AssertionError();
        }
        Logging logging = ALL;
        if (base.length() != 0) {
            int offset = 0;
            do {
                String name;
                Object[] children;
                int i;
                if ((i = Arrays.binarySearch(children = logging.children, name = (offset = base.indexOf(46, offset)) >= 0 ? base.substring(0, offset) : base, COMPARATOR)) < 0) {
                    if (!create) break;
                    children = (Logging[])XArray.insert(children, i ^= 0xFFFFFFFF, 1);
                    children[i] = new Logging(logging, name);
                    logging.children = children;
                }
                logging = children[i];
            } while (++offset != 0);
        }
        return logging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerFactory getLoggerFactory() {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggerFactory(LoggerFactory factory) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            this.factory = factory;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].setLoggerFactory(factory);
            }
            sameLoggerFactory = Logging.sameLoggerFactory(Logging.ALL.children, Logging.ALL.factory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean sameLoggerFactory(Logging[] children, LoggerFactory factory) {
        if (!$assertionsDisabled && !Thread.holdsLock(EMPTY)) {
            throw new AssertionError();
        }
        for (int i = 0; i < children.length; ++i) {
            Logging logging = children[i];
            if (logging.factory == factory && Logging.sameLoggerFactory(logging.children, factory)) continue;
            return false;
        }
        return true;
    }

    public void setLoggerFactory(String className) throws ClassNotFoundException, IllegalArgumentException {
        LoggerFactory factory;
        if (className == null) {
            factory = null;
        } else {
            Class<?> factoryClass;
            try {
                factoryClass = Class.forName(className);
            }
            catch (NoClassDefFoundError error) {
                throw Logging.factoryNotFound(className, error);
            }
            if (!LoggerFactory.class.isAssignableFrom(factoryClass)) {
                throw new IllegalArgumentException(Errors.format(45, Utilities.getShortName(factoryClass), Utilities.getShortName(LoggerFactory.class)));
            }
            try {
                Method method = factoryClass.getMethod("getInstance", null);
                factory = (LoggerFactory)method.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException) {
                    cause = e.getCause();
                }
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e;
                }
                if (cause instanceof NoClassDefFoundError) {
                    throw Logging.factoryNotFound(className, (NoClassDefFoundError)cause);
                }
                throw new IllegalArgumentException(Errors.format(184, className, cause));
            }
        }
        this.setLoggerFactory(factory);
    }

    private static ClassNotFoundException factoryNotFound(String name, NoClassDefFoundError error) {
        return new ClassNotFoundException(Errors.format(189, name), error);
    }

    public void forceMonolineConsoleOutput() {
        this.forceMonolineConsoleOutput(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMonolineConsoleOutput(Level level) {
        Logger logger = Logger.getLogger(this.name);
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            MonolineFormatter f = MonolineFormatter.configureConsoleHandler(logger, level);
            if (f.getSourceFormat() == null) {
                f.setSourceFormat("class:short");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static boolean unexpectedException(Logger logger, Throwable error) {
        if (logger.isLoggable(Level.WARNING)) {
            Logging.unexpectedException(logger.getName(), (String)null, null, error);
            return true;
        }
        return false;
    }

    public static void unexpectedException(Logger logger, Class classe, String method, Throwable error) {
        Logging.unexpectedException(logger.getName(), classe, method, error);
    }

    public static void unexpectedException(String paquet, Class classe, String method, Throwable error) {
        Logging.unexpectedException(paquet, classe != null ? classe.getName() : (String)null, method, error);
    }

    private static void unexpectedException(String paquet, String classe, String method, Throwable error) {
        LogRecord record = Utilities.getLogRecord(error);
        if (paquet == null || classe == null || method == null) {
            StackTraceElement[] elements = error.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                int lg;
                StackTraceElement e = elements[i];
                String c = e.getClassName();
                if (paquet != null) {
                    if (!c.startsWith(paquet)) continue;
                    lg = paquet.length();
                    if (c.length() > lg && Character.isJavaIdentifierPart(c.charAt(lg))) continue;
                }
                if (classe != null) {
                    if (!c.endsWith(classe)) continue;
                    lg = c.length() - classe.length() - 1;
                    if (c.length() >= 0 && Character.isJavaIdentifierPart(c.charAt(lg))) continue;
                }
                String m = e.getMethodName();
                if (method != null && !m.equals(method)) continue;
                int separator = c.lastIndexOf(46);
                if (paquet == null) {
                    String string = paquet = separator >= 1 ? c.substring(0, separator - 1) : "";
                }
                if (classe == null) {
                    classe = c.substring(separator + 1);
                }
                if (method != null) break;
                method = m;
                break;
            }
        }
        record.setSourceClassName(classe);
        record.setSourceMethodName(method);
        record.setThrown(error);
        Logger.getLogger(paquet).log(record);
    }

    static {
        $assertionsDisabled = !Logging.class.desiredAssertionStatus();
        COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = o1 instanceof Logging ? ((Logging)o1).name : o1.toString();
                String n2 = o2 instanceof Logging ? ((Logging)o2).name : o2.toString();
                return n1.compareTo(n2);
            }
        };
        EMPTY = new Logging[0];
        ALL = new Logging();
        GEOTOOLS = Logging.getLogging("org.geotools");
    }
}

