/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.geotools.util.logging.CommonsLogger;
import org.geotools.util.logging.LoggerFactory;

public class CommonsLoggerFactory
extends LoggerFactory {
    private static CommonsLoggerFactory factory;

    protected CommonsLoggerFactory() throws NoClassDefFoundError {
        super(Log.class);
    }

    public static synchronized CommonsLoggerFactory getInstance() throws NoClassDefFoundError {
        if (factory == null) {
            factory = new CommonsLoggerFactory();
        }
        return factory;
    }

    protected Object getImplementation(String name) {
        Log log = LogFactory.getLog((String)name);
        if (log instanceof Jdk14Logger) {
            return null;
        }
        return log;
    }

    protected Logger wrap(String name, Object implementation) throws ClassCastException {
        return new CommonsLogger(name, (Log)implementation);
    }

    protected Object unwrap(Logger logger) {
        if (logger instanceof CommonsLogger) {
            return ((CommonsLogger)logger).logger;
        }
        return null;
    }
}

