/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.util.MemberName;
import org.opengis.util.Record;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.TypeName;

public class RecordTypeImpl
implements RecordType {
    private TypeName typeName;
    private Map attributeTypes;
    private RecordSchema parent;

    public RecordTypeImpl(RecordSchema parent, TypeName typeName, List members) {
        this.parent = parent;
        this.typeName = typeName;
        HashMap<MemberName, TypeName> attributeTypes = new HashMap<MemberName, TypeName>();
        Iterator i = members.iterator();
        while (i.hasNext()) {
            MemberName member = (MemberName)i.next();
            attributeTypes.put(member, member.getAttributeType());
        }
        this.attributeTypes = Collections.unmodifiableMap(attributeTypes);
    }

    public RecordTypeImpl(RecordSchema parent, TypeName typeName, Map attributeTypes) {
        this.parent = parent;
        this.typeName = typeName;
        this.attributeTypes = Collections.unmodifiableMap(attributeTypes);
    }

    public Map getAttributeTypes() {
        return this.attributeTypes;
    }

    public RecordSchema getContainer() {
        return this.parent;
    }

    public Set getMembers() {
        return this.getAttributeTypes().keySet();
    }

    public TypeName getTypeName() {
        return this.typeName;
    }

    public boolean isInstance(Record record) {
        return ((Object)this.getMembers()).equals(record.getAttributes().keySet());
    }

    public TypeName locate(MemberName memberName) {
        return (TypeName)this.getAttributeTypes().get(memberName);
    }
}

