/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.geotools.io.LineWriter;
import org.geotools.resources.Utilities;
import org.geotools.util.Logging;

public class MonolineFormatter
extends Formatter {
    private static final String PREFIX = "";
    private static final String SUFFIX = " - ";
    private static final int DEFAULT_WIDTH = 9;
    private static final int NO_SOURCE = 0;
    private static final int NO_SOURCE_EX = 1;
    private static final int LOGGER_SHORT = 2;
    private static final int LOGGER_LONG = 3;
    private static final int CLASS_SHORT = 4;
    private static final int CLASS_LONG = 5;
    private static String[] FORMAT_LABELS;
    private final String lineSeparator;
    private String bodyLineSeparator;
    private final int margin;
    private final String base;
    private final long startMillis;
    private SimpleDateFormat timeFormat;
    private int sourceFormat;
    private final StringBuffer buffer;
    private final LineWriter writer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$util$logging$ConsoleHandler;
    static /* synthetic */ Class class$java$util$logging$SimpleFormatter;

    public MonolineFormatter() {
        this(PREFIX);
    }

    public MonolineFormatter(String base) {
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        this.timeFormat = null;
        this.sourceFormat = 0;
        this.startMillis = System.currentTimeMillis();
        this.margin = 9;
        this.base = base.trim();
        StringWriter str = new StringWriter();
        this.writer = new LineWriter(str);
        this.buffer = str.getBuffer();
        this.buffer.append(PREFIX);
        LogManager manager = LogManager.getLogManager();
        String classname = MonolineFormatter.class.getName();
        try {
            this.setTimeFormat(manager.getProperty(classname + ".time"));
        }
        catch (IllegalArgumentException exception) {
            System.err.println(exception);
        }
        try {
            this.setSourceFormat(manager.getProperty(classname + ".source"));
        }
        catch (IllegalArgumentException exception) {
            System.err.println(exception);
        }
    }

    public synchronized void setTimeFormat(String pattern) {
        if (pattern == null) {
            this.timeFormat = null;
        } else if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(pattern);
            this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeFormat.applyPattern(pattern);
        }
    }

    public synchronized String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat.toPattern() : null;
    }

    public synchronized void setSourceFormat(String format) {
        if (format != null) {
            format = format.trim().toLowerCase();
        }
        for (int i = 0; i < FORMAT_LABELS.length; ++i) {
            if (!Utilities.equals(FORMAT_LABELS[i], format)) continue;
            this.sourceFormat = i;
            return;
        }
        throw new IllegalArgumentException(format);
    }

    public String getSourceFormat() {
        return FORMAT_LABELS[this.sourceFormat];
    }

    public synchronized String format(LogRecord record) {
        this.buffer.setLength(PREFIX.length());
        if (this.timeFormat != null) {
            Date time = new Date(Math.max(0L, record.getMillis() - this.startMillis));
            this.timeFormat.format(time, this.buffer, new FieldPosition(0));
            this.buffer.append(' ');
        }
        int offset = this.buffer.length();
        this.buffer.append(record.getLevel().getLocalizedName());
        offset = this.buffer.length() - offset;
        this.buffer.append(Utilities.spaces(this.margin - offset));
        String logger = record.getLoggerName();
        String classname = record.getSourceClassName();
        switch (this.sourceFormat) {
            case 2: {
                if (logger.startsWith(this.base)) {
                    int pos = this.base.length();
                    if (pos < logger.length() - 1 && logger.charAt(pos) == '.') {
                        ++pos;
                    }
                    logger = logger.substring(pos);
                }
            }
            case 3: {
                this.buffer.append(' ');
                this.buffer.append(logger);
                break;
            }
            case 4: {
                int dot = classname.lastIndexOf(46);
                if (dot >= 0) {
                    classname = classname.substring(dot + 1);
                }
                classname = classname.replace('$', '.');
            }
            case 5: {
                this.buffer.append(' ');
                this.buffer.append(classname);
            }
        }
        this.buffer.append(SUFFIX);
        int margin = this.buffer.length();
        if (!$assertionsDisabled && margin < this.margin) {
            throw new AssertionError();
        }
        if (this.bodyLineSeparator.length() != this.lineSeparator.length() + margin) {
            this.bodyLineSeparator = this.lineSeparator + Utilities.spaces(margin);
        }
        try {
            this.writer.setLineSeparator(this.bodyLineSeparator);
            this.writer.write(String.valueOf(this.formatMessage(record)));
            this.writer.setLineSeparator(this.lineSeparator);
            this.writer.write(10);
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return this.buffer.toString();
    }

    public static MonolineFormatter init(String base) {
        return MonolineFormatter.init(base, null);
    }

    public static MonolineFormatter init(String base, Level level) {
        Logger logger;
        MonolineFormatter monoline = null;
        Logger scan = logger = Logger.getLogger(base);
        do {
            Handler[] handlers = scan.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Handler handler = handlers[i];
                if (handler.getClass().equals(class$java$util$logging$ConsoleHandler == null ? MonolineFormatter.class$("java.util.logging.ConsoleHandler") : class$java$util$logging$ConsoleHandler)) {
                    Formatter formatter = handler.getFormatter();
                    if (formatter instanceof MonolineFormatter) {
                        if (monoline == null) {
                            monoline = (MonolineFormatter)formatter;
                            if (level != null) {
                                handler.setLevel(level);
                            }
                        }
                    } else if (formatter.getClass().equals(class$java$util$logging$SimpleFormatter == null ? MonolineFormatter.class$("java.util.logging.SimpleFormatter") : class$java$util$logging$SimpleFormatter)) {
                        if (monoline == null) {
                            monoline = new MonolineFormatter(base);
                        }
                        try {
                            handler = new Stdout(handler, (Formatter)monoline);
                            if (level != null) {
                                handler.setLevel(level);
                            }
                        }
                        catch (UnsupportedEncodingException exception) {
                            MonolineFormatter.unexpectedException(exception);
                        }
                        catch (SecurityException exception) {
                            MonolineFormatter.unexpectedException(exception);
                        }
                    }
                }
                logger.addHandler(handler);
            }
        } while ((scan = scan.getParent()) != null && scan.getUseParentHandlers());
        if (monoline == null) {
            monoline = new MonolineFormatter(base);
            try {
                Stdout handler = new Stdout(monoline);
                if (level != null) {
                    handler.setLevel(level);
                }
                logger.addHandler(handler);
            }
            catch (SecurityException exception) {
                MonolineFormatter.unexpectedException(exception);
                return monoline;
            }
        }
        logger.setUseParentHandlers(false);
        if (level != null) {
            logger.setLevel(level);
        }
        return monoline;
    }

    public static void initGeotools() {
        MonolineFormatter.initGeotools(null);
    }

    public static void initGeotools(Level level) {
        MonolineFormatter f = MonolineFormatter.init("org.geotools", level);
        if (f.getSourceFormat() == null) {
            f.setSourceFormat("class:long");
        }
    }

    private static void unexpectedException(Exception e) {
        Logging.unexpectedException("org.geotools.util", MonolineFormatter.class, "init", (Throwable)e);
    }

    static {
        $assertionsDisabled = !MonolineFormatter.class.desiredAssertionStatus();
        FORMAT_LABELS = new String[6];
        MonolineFormatter.FORMAT_LABELS[1] = "none";
        MonolineFormatter.FORMAT_LABELS[2] = "logger:short";
        MonolineFormatter.FORMAT_LABELS[3] = "logger:long";
        MonolineFormatter.FORMAT_LABELS[4] = "class:short";
        MonolineFormatter.FORMAT_LABELS[5] = "class:long";
    }

    private static final class Stdout
    extends StreamHandler {
        public Stdout(Formatter formatter) {
            super(System.out, formatter);
        }

        public Stdout(Handler handler, Formatter formatter) throws UnsupportedEncodingException {
            super(System.out, formatter);
            this.setErrorManager(handler.getErrorManager());
            this.setFilter(handler.getFilter());
            this.setLevel(handler.getLevel());
            this.setEncoding(handler.getEncoding());
        }

        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        public void close() {
            this.flush();
        }
    }
}

