/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.util.CommonHandler;
import org.geotools.util.MonolineFormatter;

public final class Logging {
    public static final Logging GEOTOOLS;
    public static final Logging ALL;
    private final String root;
    private boolean redirected;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Logging(String root) {
        this.root = root;
    }

    public void forceMonolineConsoleOutput() throws IllegalStateException {
        this.forceMonolineConsoleOutput(null);
    }

    public synchronized void forceMonolineConsoleOutput(Level level) throws IllegalStateException {
        if (this.redirected) {
            throw new IllegalStateException();
        }
        MonolineFormatter f = MonolineFormatter.init(this.root, level);
        if (f.getSourceFormat() == null) {
            f.setSourceFormat("class:short");
        }
    }

    public synchronized boolean redirectToCommonsLogging() {
        try {
            if (CommonHandler.install(this.root)) {
                if (!$assertionsDisabled && !Logging.isCommonsLoggingAvailable()) {
                    throw new AssertionError();
                }
                this.redirected = true;
                return true;
            }
        }
        catch (NoClassDefFoundError error) {
            Utilities.recoverableException("org.geotools.util", Logging.class, "redirectToCommonsLogging", error);
        }
        return false;
    }

    public static boolean isCommonsLoggingAvailable() {
        try {
            Class.forName("org.apache.commons.logging.Log", false, Logging.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean unexpectedException(Logger logger, Throwable error) {
        if (logger.isLoggable(Level.WARNING)) {
            Logging.unexpectedException(logger.getName(), (String)null, null, error);
            return true;
        }
        return false;
    }

    public static void unexpectedException(Logger logger, Class classe, String method, Throwable error) {
        Logging.unexpectedException(logger.getName(), classe, method, error);
    }

    public static void unexpectedException(String paquet, Class classe, String method, Throwable error) {
        Logging.unexpectedException(paquet, classe != null ? classe.getName() : (String)null, method, error);
    }

    public static void unexpectedException(String paquet, String classe, String method, Throwable error) {
        LogRecord record = Utilities.getLogRecord(error);
        if (paquet == null || classe == null || method == null) {
            StackTraceElement[] elements = error.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                int lg;
                StackTraceElement e = elements[i];
                String c = e.getClassName();
                if (paquet != null) {
                    if (!c.startsWith(paquet)) continue;
                    lg = paquet.length();
                    if (c.length() > lg && Character.isJavaIdentifierPart(c.charAt(lg))) continue;
                }
                if (classe != null) {
                    if (!c.endsWith(classe)) continue;
                    lg = c.length() - classe.length() - 1;
                    if (c.length() >= 0 && Character.isJavaIdentifierPart(c.charAt(lg))) continue;
                }
                String m = e.getMethodName();
                if (method != null && !m.equals(method)) continue;
                int separator = c.lastIndexOf(46);
                if (paquet == null) {
                    String string = paquet = separator >= 1 ? c.substring(0, separator - 1) : "";
                }
                if (classe == null) {
                    classe = c.substring(separator + 1);
                }
                if (method != null) break;
                method = m;
                break;
            }
        }
        record.setSourceClassName(classe);
        record.setSourceMethodName(method);
        record.setThrown(error);
        Logger.getLogger(paquet).log(record);
    }

    static {
        $assertionsDisabled = !Logging.class.desiredAssertionStatus();
        GEOTOOLS = new Logging("org.geotools");
        ALL = new Logging("");
    }
}

