/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.LinkedHashMap;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.util.Cloneable;

public class CheckedHashMap
extends LinkedHashMap
implements Cloneable {
    private static final long serialVersionUID = -7777695267921872849L;
    private final Class keyType;
    private final Class valueType;

    public CheckedHashMap(Class keyType, Class valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        CheckedHashMap.ensureNonNull(keyType, "keyType");
        CheckedHashMap.ensureNonNull(valueType, "valueType");
    }

    private static void ensureNonNull(Class type, String name) {
        if (type == null) {
            throw new NullPointerException(Errors.format(105, name));
        }
    }

    private static void ensureValidType(Object element, Class type) throws IllegalArgumentException {
        if (element != null && !type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format(45, Utilities.getShortClassName(element), Utilities.getShortName(type)));
        }
    }

    public Object put(Object key, Object value) {
        CheckedHashMap.ensureValidType(key, this.keyType);
        CheckedHashMap.ensureValidType(value, this.valueType);
        return super.put(key, value);
    }
}

