/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Constructor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.geotools.resources.XArray;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class OptionalDependencies {
    private static Constructor treeNodeConstructor;
    private static boolean noNamedTreeNode;

    private OptionalDependencies() {
    }

    public static DefaultMutableTreeNode createTreeNode(String name, Object object, boolean allowsChildren) {
        if (!noNamedTreeNode) {
            try {
                if (treeNodeConstructor == null) {
                    treeNodeConstructor = Class.forName("org.geotools.gui.swing.tree.NamedTreeNode").getConstructor(String.class, Object.class, Boolean.TYPE);
                }
                return (DefaultMutableTreeNode)treeNodeConstructor.newInstance(name, object, allowsChildren);
            }
            catch (Exception e) {
                noNamedTreeNode = true;
            }
        }
        return new DefaultMutableTreeNode(name, allowsChildren);
    }

    public static MutableTreeNode xmlToSwing(Node node) {
        String label = node.getNodeName();
        String value = node.getNodeValue();
        if (value != null) {
            label = label + "=\"" + value + '\"';
        }
        DefaultMutableTreeNode root = OptionalDependencies.createTreeNode(label, node, true);
        NamedNodeMap attributes = node.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node attribute = attributes.item(i);
            if (attribute == null) continue;
            label = attribute.getNodeName() + "=\"" + attribute.getNodeValue() + '\"';
            root.add(OptionalDependencies.createTreeNode(label, attribute, false));
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            root.add(OptionalDependencies.xmlToSwing(child));
        }
        return root;
    }

    private static boolean[] toString(TreeModel model, Object node, StringBuffer buffer, int level, boolean[] last, String lineSeparator) {
        for (int i = 0; i < level; ++i) {
            if (i != level - 1) {
                buffer.append(last[i] ? (char)'\u00a0' : '\u2502').append("\u00a0\u00a0\u00a0");
                continue;
            }
            buffer.append(last[i] ? (char)'\u2514' : '\u251c').append("\u2500\u2500\u2500");
        }
        buffer.append(node).append(lineSeparator);
        if (level >= last.length) {
            last = XArray.resize(last, level * 2);
        }
        int count = model.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            last[level] = i == count - 1;
            last = OptionalDependencies.toString(model, model.getChild(node, i), buffer, level + 1, last, lineSeparator);
        }
        return last;
    }

    private static String toString(TreeModel tree, Object root) {
        if (root == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        OptionalDependencies.toString(tree, root, buffer, 0, new boolean[64], System.getProperty("line.separator", "\n"));
        return buffer.toString();
    }

    public static String toString(TreeModel tree) {
        return OptionalDependencies.toString(tree, tree.getRoot());
    }

    public static String toString(TreeNode node) {
        return OptionalDependencies.toString(new DefaultTreeModel(node, true));
    }

    static {
        noNamedTreeNode = false;
    }
}

