/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;

public class ElementImpl
extends MetadataEntity
implements Element {
    private static final long serialVersionUID = -3542504624077298894L;
    private Collection namesOfMeasure;
    private Identifier measureIdentification;
    private InternationalString measureDescription;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private long date1 = Long.MIN_VALUE;
    private long date2 = Long.MIN_VALUE;
    private Collection results;

    public ElementImpl() {
    }

    public ElementImpl(Element source) {
        super(source);
    }

    public ElementImpl(Result result) {
        this.setResults(Collections.singleton(result));
    }

    public synchronized Collection getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public synchronized void setNamesOfMeasure(Collection newValues) {
        this.namesOfMeasure = this.copyCollection(newValues, this.namesOfMeasure, InternationalString.class);
    }

    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public synchronized void setMeasureIdentification(Identifier newValue) {
        this.checkWritePermission();
        this.measureIdentification = newValue;
    }

    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public synchronized void setMeasureDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.measureDescription = newValue;
    }

    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public synchronized void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.checkWritePermission();
        this.evaluationMethodType = newValue;
    }

    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public synchronized void setEvaluationMethodDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.evaluationMethodDescription = newValue;
    }

    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public synchronized void setEvaluationProcedure(Citation newValue) {
        this.checkWritePermission();
        this.evaluationProcedure = newValue;
    }

    public Date[] getDate() {
        if (this.date1 == Long.MIN_VALUE) {
            return null;
        }
        if (this.date2 == Long.MIN_VALUE) {
            return new Date[]{new Date(this.date1)};
        }
        return new Date[]{new Date(this.date1), new Date(this.date2)};
    }

    public synchronized Collection getDates() {
        if (this.date1 == Long.MIN_VALUE) {
            return Collections.EMPTY_LIST;
        }
        if (this.date2 == Long.MIN_VALUE) {
            return Collections.singleton(new Date(this.date1));
        }
        return Arrays.asList(new Date(this.date1), new Date(this.date2));
    }

    public synchronized void setDate(Date[] newValue) {
        this.checkWritePermission();
        this.date2 = Long.MIN_VALUE;
        this.date1 = Long.MIN_VALUE;
        if (newValue != null) {
            switch (newValue.length) {
                default: {
                    throw new IllegalArgumentException(Errors.format(67));
                }
                case 2: {
                    this.date2 = newValue[1].getTime();
                }
                case 1: {
                    this.date1 = newValue[0].getTime();
                }
                case 0: 
            }
        }
    }

    public void setDates(Collection newValues) {
        this.setDate(newValues.toArray(new Date[newValues.size()]));
    }

    public Result getResult() {
        Collection results = this.getResults();
        return results.isEmpty() ? null : (Result)results.iterator().next();
    }

    public void setResult(Result newValue) {
        this.setResults(Collections.singleton(newValue));
    }

    public synchronized Collection getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public synchronized void setResults(Collection newValues) {
        this.results = this.copyCollection(newValues, this.results, Result.class);
    }
}

