/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import org.geotools.metadata.iso.identification.IdentificationImpl;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.util.InternationalString;

public class DataIdentificationImpl
extends IdentificationImpl
implements DataIdentification {
    private static final long serialVersionUID = -4418520352804939785L;
    private Collection spatialRepresentationTypes;
    private Collection spatialResolutions;
    private Collection language;
    private Collection characterSets;
    private Collection topicCategories;
    private Collection geographicBox;
    private Collection geographicDescription;
    private InternationalString environmentDescription;
    private Collection extent;
    private InternationalString supplementalInformation;

    public DataIdentificationImpl() {
    }

    public DataIdentificationImpl(DataIdentification source) {
        super(source);
    }

    public DataIdentificationImpl(Citation citation, InternationalString abstracts, Collection language, Collection topicCategories) {
        super(citation, abstracts);
        this.setLanguage(language);
        this.setTopicCategories(topicCategories);
    }

    public synchronized Collection getSpatialRepresentationTypes() {
        this.spatialRepresentationTypes = this.nonNullCollection(this.spatialRepresentationTypes, SpatialRepresentationType.class);
        return this.spatialRepresentationTypes;
    }

    public synchronized void setSpatialRepresentationTypes(Collection newValues) {
        this.spatialRepresentationTypes = this.copyCollection(newValues, this.spatialRepresentationTypes, SpatialRepresentationType.class);
    }

    public synchronized Collection getSpatialResolutions() {
        this.spatialResolutions = this.nonNullCollection(this.spatialResolutions, Resolution.class);
        return this.spatialResolutions;
    }

    public synchronized void setSpatialResolutions(Collection newValues) {
        this.spatialResolutions = this.copyCollection(newValues, this.spatialResolutions, Resolution.class);
    }

    public synchronized Collection getLanguage() {
        this.language = this.nonNullCollection(this.language, Locale.class);
        return this.language;
    }

    public synchronized void setLanguage(Collection newValues) {
        this.language = this.copyCollection(newValues, this.language, Locale.class);
    }

    public Charset getCharacterSet() {
        Collection characterSet = this.getCharacterSets();
        return characterSet.isEmpty() ? null : ((CharacterSet)characterSet.iterator().next()).toCharset();
    }

    public synchronized Collection getCharacterSets() {
        this.characterSets = this.nonNullCollection(this.characterSets, CharacterSet.class);
        return this.characterSets;
    }

    public synchronized void setCharacterSet(Charset newValue) {
        throw new UnsupportedOperationException();
    }

    public synchronized void setCharacterSets(Collection newValues) {
        this.characterSets = this.copyCollection(newValues, this.characterSets, CharacterSet.class);
    }

    public synchronized Collection getTopicCategories() {
        this.topicCategories = this.nonNullCollection(this.topicCategories, TopicCategory.class);
        return this.topicCategories;
    }

    public synchronized void setTopicCategories(Collection newValues) {
        this.topicCategories = this.copyCollection(newValues, this.topicCategories, TopicCategory.class);
    }

    public synchronized Collection getGeographicBox() {
        this.geographicBox = this.nonNullCollection(this.geographicBox, GeographicBoundingBox.class);
        return this.geographicBox;
    }

    public synchronized void setGeographicBox(Collection newValues) {
        this.geographicBox = this.copyCollection(newValues, this.geographicBox, GeographicBoundingBox.class);
    }

    public synchronized Collection getGeographicDescription() {
        this.geographicDescription = this.nonNullCollection(this.geographicDescription, InternationalString.class);
        return this.geographicDescription;
    }

    public synchronized void setGeographicDescription(Collection newValues) {
        this.geographicDescription = this.copyCollection(newValues, this.geographicDescription, InternationalString.class);
    }

    public InternationalString getEnvironmentDescription() {
        return this.environmentDescription;
    }

    public synchronized void setEnvironmentDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.environmentDescription = newValue;
    }

    public synchronized Collection getExtent() {
        this.extent = this.nonNullCollection(this.extent, Extent.class);
        return this.extent;
    }

    public synchronized void setExtent(Collection newValues) {
        this.extent = this.copyCollection(newValues, this.extent, Extent.class);
    }

    public InternationalString getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public synchronized void setSupplementalInformation(InternationalString newValue) {
        this.checkWritePermission();
        this.supplementalInformation = newValue;
    }
}

