/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.util.Collection;
import java.util.Iterator;
import org.geotools.metadata.ModifiableMetadata;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.util.InternationalString;

public class ExtentImpl
extends MetadataEntity
implements Extent {
    private static final long serialVersionUID = 7812213837337326257L;
    public static final Extent WORLD;
    private InternationalString description;
    private Collection geographicElements;
    private Collection temporalElements;
    private Collection verticalElements;

    public ExtentImpl() {
    }

    public ExtentImpl(Extent source) {
        super(source);
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public synchronized Collection getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return this.geographicElements;
    }

    public synchronized void setGeographicElements(Collection newValues) {
        this.geographicElements = this.copyCollection(newValues, this.geographicElements, GeographicExtent.class);
    }

    public synchronized Collection getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return this.temporalElements;
    }

    public synchronized void setTemporalElements(Collection newValues) {
        this.temporalElements = this.copyCollection(newValues, this.temporalElements, TemporalExtent.class);
    }

    public synchronized Collection getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return this.verticalElements;
    }

    public synchronized void setVerticalElements(Collection newValues) {
        this.verticalElements = this.copyCollection(newValues, this.verticalElements, VerticalExtent.class);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        Object candidate = null;
        if (extent != null) {
            ModifiableMetadata modifiable = null;
            Iterator it = extent.getGeographicElements().iterator();
            while (it.hasNext()) {
                GeographicExtent element = (GeographicExtent)it.next();
                if (!(element instanceof GeographicBoundingBox)) {
                    if (!(element instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeographicBoundingBox bounds = (GeographicBoundingBox)element;
                if (candidate == null) {
                    Boolean inclusion = bounds.getInclusion();
                    ExtentImpl.ensureNonNull("inclusion", inclusion);
                    if (!inclusion.booleanValue()) continue;
                    candidate = bounds;
                    continue;
                }
                if (modifiable == null) {
                    modifiable = new GeographicBoundingBoxImpl((GeographicBoundingBox)candidate);
                    candidate = modifiable;
                }
                ((GeographicBoundingBoxImpl)modifiable).add(bounds);
            }
            if (modifiable != null) {
                modifiable.freeze();
            }
        }
        return candidate;
    }

    static {
        ExtentImpl world = new ExtentImpl();
        world.getGeographicElements().add(GeographicBoundingBoxImpl.WORLD);
        world.freeze();
        WORLD = world;
    }
}

