/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

public class CitationImpl
extends MetadataEntity
implements Citation {
    private static final long serialVersionUID = -4415559967618358778L;
    private InternationalString title;
    private Collection alternateTitles;
    private Collection dates;
    private InternationalString edition;
    private long editionDate = Long.MIN_VALUE;
    private Collection identifiers;
    private Collection identifierTypes;
    private Collection citedResponsibleParties;
    private Collection presentationForm;
    private Series series;
    private InternationalString otherCitationDetails;
    private InternationalString collectiveTitle;
    private String ISBN;
    private String ISSN;

    public CitationImpl() {
    }

    public CitationImpl(Citation source) {
        super(source);
    }

    public CitationImpl(CharSequence title) {
        InternationalString t = title instanceof InternationalString ? (InternationalString)title : new SimpleInternationalString(((Object)title).toString());
        this.setTitle(t);
    }

    public CitationImpl(ResponsibleParty party) {
        String name;
        InternationalString title = party.getOrganisationName();
        if (title == null && (title = party.getPositionName()) == null && (name = party.getIndividualName()) != null) {
            title = new SimpleInternationalString(name);
        }
        this.setTitle(title);
        this.getCitedResponsibleParties().add(party);
    }

    final void addAuthority(String identifier, boolean asTitle) {
        if (asTitle) {
            this.getAlternateTitles().add(new SimpleInternationalString(identifier));
        }
        this.getIdentifierTypes().add("Authority name");
        this.getIdentifiers().add(identifier);
    }

    public InternationalString getTitle() {
        return this.title;
    }

    public synchronized void setTitle(InternationalString newValue) {
        this.checkWritePermission();
        this.title = newValue;
    }

    public synchronized Collection getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public synchronized void setAlternateTitles(Collection newValues) {
        this.alternateTitles = this.copyCollection(newValues, this.alternateTitles, InternationalString.class);
    }

    public synchronized Collection getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public synchronized void setDates(Collection newValues) {
        this.dates = this.copyCollection(newValues, this.dates, CitationDate.class);
    }

    public InternationalString getEdition() {
        return this.edition;
    }

    public synchronized void setEdition(InternationalString newValue) {
        this.checkWritePermission();
        this.edition = newValue;
    }

    public synchronized Date getEditionDate() {
        return this.editionDate != Long.MIN_VALUE ? new Date(this.editionDate) : null;
    }

    public synchronized void setEditionDate(Date newValue) {
        this.checkWritePermission();
        this.editionDate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public synchronized Collection getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, String.class);
        return this.identifiers;
    }

    public synchronized void setIdentifiers(Collection newValues) {
        this.identifiers = this.copyCollection(newValues, this.identifiers, String.class);
    }

    public synchronized Collection getIdentifierTypes() {
        this.identifierTypes = this.nonNullCollection(this.identifierTypes, String.class);
        return this.identifierTypes;
    }

    public synchronized void setIdentifierTypes(Collection newValues) {
        this.identifierTypes = this.copyCollection(newValues, this.identifierTypes, String.class);
    }

    public synchronized Collection getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public synchronized void setCitedResponsibleParties(Collection newValues) {
        this.citedResponsibleParties = this.copyCollection(newValues, this.citedResponsibleParties, ResponsibleParty.class);
    }

    public synchronized Collection getPresentationForm() {
        this.presentationForm = this.nonNullCollection(this.presentationForm, PresentationForm.class);
        return this.presentationForm;
    }

    public synchronized void setPresentationForm(Collection newValues) {
        this.presentationForm = this.copyCollection(newValues, this.presentationForm, PresentationForm.class);
    }

    public Series getSeries() {
        return this.series;
    }

    public synchronized void setSeries(Series newValue) {
        this.checkWritePermission();
        this.series = newValue;
    }

    public InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public synchronized void setOtherCitationDetails(InternationalString newValue) {
        this.checkWritePermission();
        this.otherCitationDetails = newValue;
    }

    public InternationalString getCollectiveTitle() {
        return this.collectiveTitle;
    }

    public synchronized void setCollectiveTitle(InternationalString newValue) {
        this.checkWritePermission();
        this.collectiveTitle = newValue;
    }

    public String getISBN() {
        return this.ISBN;
    }

    public synchronized void setISBN(String newValue) {
        this.checkWritePermission();
        this.ISBN = newValue;
    }

    public String getISSN() {
        return this.ISSN;
    }

    public synchronized void setISSN(String newValue) {
        this.checkWritePermission();
        this.ISSN = newValue;
    }
}

