/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.metadata.PropertyAccessor;
import org.geotools.resources.Utilities;

final class PropertyMap
extends AbstractMap {
    private final Object metadata;
    private final PropertyAccessor accessor;
    private final Set entrySet;

    public PropertyMap(Object metadata, PropertyAccessor accessor) {
        this.metadata = metadata;
        this.accessor = accessor;
        this.entrySet = new Entries();
    }

    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        Object value = this.accessor.get(this.accessor.indexOf((String)key), this.metadata);
        return PropertyAccessor.isEmpty(value) ? null : value;
    }

    public Object put(Object key, Object value) throws IllegalArgumentException {
        return this.accessor.set(this.accessor.indexOf((String)key), this.metadata, value);
    }

    public Object remove(Object key) {
        return this.put(key, (Object)null);
    }

    public Set entrySet() {
        return this.entrySet;
    }

    private final class Entries
    extends AbstractSet {
        Entries() {
        }

        public Iterator iterator() {
            return new Iter();
        }

        public int size() {
            return PropertyMap.this.accessor.count(PropertyMap.this.metadata, Integer.MAX_VALUE);
        }

        public boolean isEmpty() {
            return PropertyMap.this.accessor.count(PropertyMap.this.metadata, 1) == 0;
        }

        public boolean contains(Object object) {
            Map.Entry entry;
            Object key;
            if (object instanceof Map.Entry && (key = (entry = (Map.Entry)object).getKey()) instanceof String) {
                return new Property((String)key).equals(entry);
            }
            return false;
        }
    }

    private final class Iter
    implements Iterator {
        private Property current;
        private Property next;

        Iter() {
            this.move(0);
        }

        private void move(int index) {
            int count = PropertyMap.this.accessor.count();
            while (index < count) {
                if (!PropertyAccessor.isEmpty(PropertyMap.this.accessor.get(index, PropertyMap.this.metadata))) {
                    this.next = new Property(index);
                    return;
                }
                ++index;
            }
            this.next = null;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next != null) {
                this.current = this.next;
                this.move(this.next.index + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue((Object)null);
            this.current = null;
        }
    }

    private final class Property
    implements Map.Entry {
        final int index;

        Property(int index) {
            this.index = index;
        }

        Property(String property) {
            this.index = PropertyMap.this.accessor.indexOf(property);
        }

        public Object getKey() {
            return PropertyMap.this.accessor.name(this.index);
        }

        public Object getValue() {
            Object value = PropertyMap.this.accessor.get(this.index, PropertyMap.this.metadata);
            return PropertyAccessor.isEmpty(value) ? null : value;
        }

        public Object setValue(Object value) {
            return PropertyMap.this.accessor.set(this.index, PropertyMap.this.metadata, value);
        }

        public boolean equals(Map.Entry entry) {
            return Utilities.equals(this.getKey(), entry.getKey()) && Utilities.equals(this.getValue(), entry.getValue());
        }

        public boolean equals(Object object) {
            return object instanceof Map.Entry && this.equals((Map.Entry)object);
        }

        public int hashCode() {
            Object x = this.getKey();
            int code = x != null ? x.hashCode() : 0;
            x = this.getValue();
            if (x != null) {
                code ^= x.hashCode();
            }
            return code;
        }
    }
}

